/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rydeen.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.util.BcReaderThread_0;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.dao.XdtsProfileDAO;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.server.XdtsRowCopyTask;
import jp.co.extreme.module.xdts.server.XdtsServerUtil;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.rydeen.script.ScriptTask;
import jp.co.extreme.rydeen.script.XdtsTempCondition;
import jp.co.extreme.scf4.fx.TmpMonitorPane;
import jp.co.extreme.script.SrpUtil;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.task.TskAbstractCallable2;
import jp.co.extreme.task.TskCallableUnit;
import jp.co.extreme.task.TskTaskEvent;
import jp.co.extreme.task.TskTaskManager;

public class ScriptHelper
extends BcLoggableObject {
    private List<SqlConnection> sqlConnectionList = new ArrayList<SqlConnection>();

    private ScriptHelper() {
    }

    public static ScriptHelper getInstance() {
        return SingletonHolder.instance;
    }

    public SqlConnection getConnection(String dataSourceName) throws Exception {
        this.getLogger().info("getConnection:dataSourceName=" + dataSourceName);
        DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSessionMain = dtsSessionFactoryMain.createSession(this);){
            XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getByName(dtsSessionMain, dataSourceName);
            this.getLogger().info("profile=" + profile);
            DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().createSessionFactory(profile);
            DtsSession dtsSessionWk = dtsSessionFactoryWk1.createSession(this);
            SqlConnection sqlConn = dtsSessionWk.getConnection();
            this.getLogger().info("sqlConn=" + sqlConn);
            this.sqlConnectionList.add(sqlConn);
            return sqlConn;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void closeConnections() throws Exception {
        int i = 0;
        while (i < this.sqlConnectionList.size()) {
            SqlConnection sqlConn = this.sqlConnectionList.get(1);
            if (!sqlConn.isClosed()) {
                sqlConn.close();
                this.getLogger().info("Connection closed.hashCode=" + sqlConn.hashCode());
            }
            ++i;
        }
    }

    public SqlResultSet executeSelect(SqlConnection conn, String query) throws Exception {
        SqlStatement stmt = conn.createStatement();
        return stmt.executeQuery(query);
    }

    public int executeUpdate(SqlConnection conn, String query) throws Exception {
        int cnt = 0;
        try {
            cnt = SqlUtil.executeUpdate(conn, query);
            this.getLogger().info("cnt=" + cnt);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        return cnt;
    }

    public boolean existTable(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        return sqlContext.existTable(conn, tableName);
    }

    public int dropTable(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        return sqlContext.dropTable(conn, tableName);
    }

    public int truncateTable(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        return sqlContext.truncateTable(conn, tableName);
    }

    public MmdModel createModel(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        MmdModel mmdModel = sqlContext.createModelMetaData(conn, tableName);
        return mmdModel;
    }

    public MmdModel createModel(SqlResultSet rs, String tableName) throws Exception {
        return XdtsServerUtil.getInstance().createMmdModelForSelect(rs.getMetaData(), tableName);
    }

    public MmdModel convertModel(SqlContext srcSqlContext, MmdModel srcTableModel, SqlContext dstSqlContext) throws Exception {
        SqlDefinitionCondition definitionCondition = SqlDefinitionCondition.createDefault();
        XdtsRowCopyTask rowCopyTask = new XdtsRowCopyTask();
        return rowCopyTask.createTablePre(srcSqlContext, srcTableModel, dstSqlContext, definitionCondition);
    }

    public String createCreateTableQuery(SqlContext sqlContext, MmdModel mmdModel, boolean includePrimaryKey) throws Exception {
        SqlDefinitionCondition definitionCondition = SqlDefinitionCondition.createDefault();
        return sqlContext.createCreateTableQuery(mmdModel, includePrimaryKey, definitionCondition);
    }

    public String createCreateIndexQuery(SqlContext sqlContext, MmdModel mmdModel, MmdIndex mmdIndex) throws Exception {
        return sqlContext.createCreateIndexQuery(mmdModel, mmdIndex);
    }

    public long copyResultSet(SqlResultSet rs, SqlConnection dstConn, MmdModel mmdModel) throws Exception {
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        OutputStreamWriter errorWriter = this.createErrorWriter(processCondition);
        boolean ignoreException = false;
        XdtsRowCopyTask rowCopyTask = new XdtsRowCopyTask();
        rowCopyTask.setLogger(this.getLogger());
        return rowCopyTask.copyRow_L5(rs, dstConn, mmdModel, ignoreException, errorWriter);
    }

    public long copyResultSet(SqlResultSet rs, String tableName, SqlConnection dstConn, XdtsTempCondition condition) throws Exception {
        SqlConnection srcConn = rs.getStatement().getConnection();
        SqlContext srcSqlContext = srcConn.getSqlContext();
        SqlContext dstSqlContext = dstConn.getSqlContext();
        MmdModel srcModel = this.createModel(srcConn, tableName);
        MmdModel dstModel = this.convertModel(srcSqlContext, srcModel, dstSqlContext);
        boolean existTable = XdtsServerUtil.getInstance().dropTable(dstConn, tableName, true, true, true);
        if (!existTable) {
            String createTableQuery = this.createCreateTableQuery(dstSqlContext, dstModel, false);
            this.getLogger().info("createTableQuery=" + createTableQuery);
            this.executeUpdate(dstConn, createTableQuery);
        }
        long count = this.copyResultSet(rs, dstConn, dstModel);
        return count;
    }

    public void selectCopy_xxx(SqlResultSet rs, SqlConnection dstConn, String dstTableName, XdtsTempCondition condition) throws Exception {
        SqlContext sqlContext1 = rs.getStatement().getSqlContext();
        SqlContext sqlContext2 = dstConn.getSqlContext();
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        processCondition.commitMode = XdtsConstants.CommitMode.FINAL;
        processCondition.recreateTable = true;
        processCondition.truncateTable = true;
        processCondition.copyRow = true;
        OutputStreamWriter errorWriter = this.createErrorWriter(processCondition);
        XdtsRowCopyTask rowCopyTask = new XdtsRowCopyTask();
        rowCopyTask.setLogger(this.getLogger());
        MmdModel mmdModel1 = XdtsServerUtil.getInstance().createMmdModelForSelect(rs.getMetaData(), dstTableName);
        MmdModel mmdModel2 = rowCopyTask.createTablePre(sqlContext1, mmdModel1, sqlContext2, processCondition.definitionCondition);
        boolean existTable = XdtsServerUtil.getInstance().dropTable(dstConn, dstTableName, true, true, true);
        if (!existTable) {
            String createTableQuery = this.createCreateTableQuery(sqlContext2, mmdModel2, false);
            this.getLogger().info("createTableQuery=" + createTableQuery);
            this.executeUpdate(dstConn, createTableQuery);
        }
        rowCopyTask.createTable(processCondition, mmdModel2, dstConn, errorWriter);
        boolean ignoreException = false;
        rowCopyTask.copyRow_L5(rs, dstConn, mmdModel2, ignoreException, errorWriter);
    }

    public OutputStreamWriter createErrorWriter(XdtsProcessCondition processCondition) throws Exception {
        File errorFile = null;
        errorFile = BcStringUtil.isEmpty(processCondition.errorFilePath) ? new File(AfbApplication.getInstance().getLogDir(), "error.log") : new File(processCondition.errorFilePath);
        this.getLogger().info("errorFile=" + errorFile.getPath());
        BcFileUtil.makeParent(errorFile);
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, false), BcConstants.charset.name());
        return errorWriter;
    }

    public List<String> getTableNameList(SqlConnection conn, String namePattern) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        List<String> tableNameList = sqlContext.getTableNameList(conn, namePattern);
        return tableNameList;
    }

    public List<String> getViewNameList(SqlConnection conn, String namePattern) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        List<String> tableNameList = sqlContext.getViewNameList(conn, namePattern);
        return tableNameList;
    }

    public void executeScript(ScriptEngine scriptEngine, String script, Writer writer, Writer errorWriter, BcLogger logger) throws Exception {
        Invocable invocable = (Invocable)((Object)scriptEngine);
        try {
            try {
                if (writer != null) {
                    scriptEngine.getContext().setWriter(writer);
                }
                if (errorWriter != null) {
                    scriptEngine.getContext().setErrorWriter(errorWriter);
                }
                scriptEngine.eval(script);
            }
            catch (Exception ex) {
                logger.error(ex);
                try {
                    this.closeConnections();
                }
                catch (Exception ex2) {
                    logger.error(ex2);
                }
            }
        }
        finally {
            try {
                this.closeConnections();
            }
            catch (Exception ex) {
                logger.error(ex);
            }
        }
    }

    public void executeScript(ScriptTask scriptTask) throws Exception {
        scriptTask.setLogger(this.getLogger());
        scriptTask.rydeen = this;
        TskCallableUnit callableUnit = new TskCallableUnit((TskAbstractCallable2)scriptTask, Executors.newCachedThreadPool());
        TskTaskManager.getInstance().addCallableUnit(callableUnit);
    }

    public void executeScript(String script, BcEventHandler<TskTaskEvent> eventHandler, Writer writer, Writer errorWriter, BcLogger logger) throws Exception {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptTask scriptTask = new ScriptTask();
        scriptTask.scriptEngine = scriptEngineManager.getEngineByName("javascript");
        scriptTask.script = script;
        scriptTask.addEventHandler(eventHandler);
        scriptTask.writer = writer;
        scriptTask.errorWriter = errorWriter;
        this.executeScript(scriptTask);
    }

    public void executeScript(File scriptFile, final BcLogger logger) throws Exception {
        final ScriptTask scriptTask = new ScriptTask();
        scriptTask.setName(scriptFile.getPath());
        logger.info("scriptFile=" + scriptFile.getPath());
        String fileExtention = BcFileUtil.getExtention(scriptFile);
        logger.info("fileExtention=" + fileExtention);
        ScriptEngineFactory scriptEngineFactory = SrpUtil.getEngineFactoryByFileExtension(fileExtention);
        logger.info("scriptEngineFactory=" + scriptEngineFactory.getEngineName());
        if (scriptEngineFactory == null) {
            String msg = String.format("Not suported file extention '%s'", fileExtention);
            throw new Exception(msg);
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        logger.info("scriptEngineFactory.getNames()=" + scriptEngineFactory.getNames());
        String engineName = scriptEngineFactory.getNames().get(0);
        logger.info("engineName=" + engineName);
        scriptTask.scriptEngine = scriptEngineManager.getEngineByName(engineName);
        if (scriptTask.scriptEngine == null) {
            String msg = String.format("ScriptEngine is null.", new Object[0]);
            throw new Exception(msg);
        }
        scriptTask.script = BcFileUtil.readAsString(scriptFile, BcConstants.charset);
        logger.info("script=" + scriptTask.script);
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TmpMonitorPane monitorPane = new TmpMonitorPane();
                    monitorPane.setTitle(scriptTask.getName());
                    scriptTask.addEventHandler(monitorPane);
                    ScriptHelper.this.executeScript(scriptTask);
                }
                catch (Exception ex) {
                    logger.error(ex);
                }
            }
        });
    }

    /* synthetic */ ScriptHelper(ScriptHelper scriptHelper) {
        this();
    }

    class InnerReaderThread
    extends BcReaderThread_0 {
        public InnerReaderThread(BufferedReader br) {
            super(br);
        }

        @Override
        protected void output(String line) {
            ScriptHelper.this.getLogger().info(line);
        }
    }

    private static final class SingletonHolder {
        private static final ScriptHelper instance = new ScriptHelper(null);

        private SingletonHolder() {
        }
    }
}

