/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.orm.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.persistence.OrmAcquisitionHandler;
import jp.co.extreme.orm.persistence.OrmEntityContext;
import jp.co.extreme.orm.persistence.OrmEntityContextManager;
import jp.co.extreme.orm.persistence.OrmPersistenceProxy;
import jp.co.extreme.orm.persistence.OrmPersistenceUtil;
import jp.co.extreme.sql.SqlResultSet;

public class OrmAbstractDAO<T>
extends BcLoggableObject {
    private Class<T> entityClass;
    private OrmEntityContext entityContext;
    private OrmPersistenceProxy persistenceProxy;
    protected String tableName;
    protected String viewName;
    protected List<String> updateColumnList;

    public OrmAbstractDAO(T ... t) {
        Class<?> classType = t.getClass().getComponentType();
        this.setEntityClass(classType);
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrmEntityContext getEntityContext() throws Exception {
        if (this.entityContext == null) {
            OrmAbstractDAO ormAbstractDAO = this;
            synchronized (ormAbstractDAO) {
                if (this.entityContext == null) {
                    this.entityContext = OrmEntityContextManager.getInstance().getEntityContext(this.entityClass);
                }
            }
        }
        return this.entityContext;
    }

    public OrmPersistenceProxy createPersistenceProxy() throws Exception {
        return OrmPersistenceProxy.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrmPersistenceProxy getPersistenceProxy() throws Exception {
        if (this.persistenceProxy == null) {
            OrmAbstractDAO ormAbstractDAO = this;
            synchronized (ormAbstractDAO) {
                if (this.persistenceProxy == null) {
                    this.persistenceProxy = this.createPersistenceProxy();
                }
            }
        }
        return this.persistenceProxy;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public int putEntity(DtsSession dtsSession, int userId, T entity) throws Exception {
        return this.getPersistenceProxy().putEntitys_2(dtsSession, userId, this.tableName, entity);
    }

    public int putEntity(DtsSession dtsSession, T entity) throws Exception {
        return this.putEntity(dtsSession, -1, entity);
    }

    public int putEntitys(DtsSession dtsSession, int userId, Collection<T> entityCollection) throws Exception {
        return this.getPersistenceProxy().putEntitys_2(dtsSession, userId, this.tableName, entityCollection);
    }

    public int putEntityCollection(DtsSession dtsSession, Collection<T> entityCollection) throws Exception {
        int userId = -1;
        return this.getPersistenceProxy().putEntityCollection(dtsSession, userId, this.tableName, entityCollection);
    }

    public void getEntity(DtsSession dtsSession, SqlResultSet rs, T entity) throws Exception {
        this.getPersistenceProxy().getEntity(dtsSession, rs, entity);
    }

    public T getEntity(DtsSession dtsSession, String query) throws Exception {
        return (T)OrmPersistenceUtil.getEntity(this.getPersistenceProxy(), dtsSession, this.entityClass, query);
    }

    public void getEntityList(DtsSession dtsSession, String query, Collection<T> entityCollection) throws Exception {
        OrmPersistenceUtil.getEntitys(this.getPersistenceProxy(), dtsSession, this.entityClass, query, entityCollection);
    }

    public List<T> getEntityList(DtsSession dtsSession, String query) throws Exception {
        ArrayList entityList = new ArrayList();
        OrmPersistenceUtil.getEntitys(this.getPersistenceProxy(), dtsSession, this.entityClass, query, entityList);
        return entityList;
    }

    public void getEntitys(DtsSession dtsSession, String query, OrmAcquisitionHandler acquisitionHandler) throws Exception {
        OrmPersistenceUtil.getEntitys(this.getPersistenceProxy(), dtsSession, this.entityClass, query, acquisitionHandler);
    }

    public int deleteEntity(DtsSession dtsSession, T entity) throws Exception {
        return this.getPersistenceProxy().deleteEntity(dtsSession, this.tableName, entity);
    }

    public List<String> getColumnNameList(String asTable) throws Exception {
        List<String> columnNameList = this.getEntityContext().getColumnNameList(asTable);
        return columnNameList;
    }

    public List<String> getColumnNameList() throws Exception {
        return this.getColumnNameList(null);
    }
}

