/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.io.BcStreamFilter;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.base.table.BcCsvToTable;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.nlp.NlpWord;

public class NlpPersonNameUtil {
    public static String key = "ABRACADABRA";
    public static String person_name_ja_dat = "person_name_ja.dat";
    public static String person_name_en_dat = "person_name_en.dat";
    public static String lastNameDat = "last_name.dat";
    public static String firstNameManDat = "first_name_man.dat";
    public static String firstNameWomanDat = "first_name_woman.dat";

    public static ByteArrayInputStream decode(InputStream is) throws Exception {
        InneerStreamTransmitter streamTransmitter = new InneerStreamTransmitter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        streamTransmitter.transmit(is, baos);
        is.close();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static Map<String, NlpWord> createNounMap(InputStream is, boolean isEn) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(is, BcConstants.charset);
        BcTableModel tableModel = BcCsvToTable.getInstance().csvToTable(inputStreamReader, -1);
        LinkedHashMap<String, NlpWord> nounMap = new LinkedHashMap<String, NlpWord>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            NlpWord noun = new NlpWord();
            noun.key = (String)tableModel.getValueAt(i, 0);
            if (isEn) {
                noun.key = noun.key.toLowerCase();
            }
            noun.text = (String)tableModel.getValueAt(i, 1);
            noun.reading = (String)tableModel.getValueAt(i, 2);
            noun.score = 2;
            nounMap.put(noun.key, noun);
            ++i;
        }
        return nounMap;
    }

    public static Map<String, NlpWord> createNounMap(File file, boolean isEn) throws Exception {
        FileInputStream is = new FileInputStream(file);
        return NlpPersonNameUtil.createNounMap(is, isEn);
    }

    public static class InneerStreamTransmitter
    extends BcStreamTransmitter {
        BcStreamFilter streamFilter = new BcStreamFilter(key);

        public InneerStreamTransmitter() {
            this.setBufferSize(1024000);
        }

        @Override
        protected byte[] read(byte[] bytes, int length) {
            byte[] bytes2 = new byte[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                if (i < length) {
                    byte filter = this.streamFilter.getNextByte();
                    bytes2[i] = (byte)(bytes[i] ^ filter);
                } else {
                    bytes2[i] = bytes[i];
                }
                ++i;
            }
            return bytes2;
        }
    }
}

