/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.rmo;

import java.util.ArrayList;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.model.Wbs1ArticleCondition;
import jp.co.extreme.module.wbs1.server.Wbs1ServerUtil;
import jp.co.extreme.module.xsod.common.XsodWords;
import jp.co.extreme.module.xsod.dao.XsodCategoryDAO;
import jp.co.extreme.module.xsod.model.XsodCategory;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf3.server.ScfQueryTask;
import jp.co.extreme.scf8.util.KscfKeywordUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XsodCategoryRMO
extends RmiAbstractRMO {
    public static final String METHOD_getMerchandiseCategory = "getMerchandiseCategory";
    public static final String METHOD_putMerchandiseCategory = "putMerchandiseCategory";
    public static final String METHOD_merchandiseCategoryList = "merchandiseCategoryList";

    public void putMerchandiseCategory(RmiRmoArgument rmoArg) throws Exception {
        XsodCategory merchandiseCategory = (XsodCategory)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            XsodCategoryDAO.getInstance().putEntity(dtsSession, merchandiseCategory);
            dtsSession.commit();
            rmoArg.getRespons().addData(merchandiseCategory);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getMerchandiseCategory(RmiRmoArgument rmoArg) throws Exception {
        String merchandiseCategoryCode = rmoArg.getRequest().getDataAsString();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            XsodCategory merchandiseCategory = XsodCategoryDAO.getInstance().getByCode(dtsSession, merchandiseCategoryCode);
            rmoArg.getRespons().addData(merchandiseCategory);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void merchandiseCategoryList(RmiRmoArgument rmoArg) throws Exception {
        Wbs1ArticleCondition articleCondition = (Wbs1ArticleCondition)rmoArg.getRequest().getData();
        DtsSession dtsSessionWk = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);
        SqlContext sqlContext = dtsSessionWk.getSqlContext();
        ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSessionWk);
        queryTask.wordManager = rmoArg.getDtsSession((Object)this).getSessionFactory().wordManager;
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.setColumnNameList(selectQuery);
        this.parseCondition(dtsSessionWk, selectQuery, articleCondition);
        this.getFromClause(selectQuery);
        this.setOrderByPhrase(selectQuery);
        queryTask.query = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("query=" + queryTask.query);
        queryTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryTask.tableContext.title = XsodWords.getInstance().\u30ab\u30c6\u30b4\u30ea\u30ea\u30b9\u30c8.toString();
        queryTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery, Wbs1ArticleCondition articleCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        if (!BcStringUtil.isEmpty(articleCondition.keyword)) {
            String keywords = KscfKeywordUtil.conv(articleCondition.keyword);
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(String.valueOf(articleCondition.tableName) + ".text_1" + sqlContext.toKeyword(keywords));
            sb.append(" OR ");
            sb.append(String.valueOf(articleCondition.tableName) + ".text_2" + sqlContext.toKeyword(keywords));
            sb.append(")");
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sb.toString());
            selectQuery.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlSelectQuery selectQuery) throws Exception {
        ArrayList<String> tmpSelectColumnNameList = new ArrayList<String>();
        tmpSelectColumnNameList.addAll(selectQuery.getSelectColumnList());
        selectQuery.getSelectColumnList().clear();
        selectQuery.getSelectColumnList().add("xsod_category.set_id");
        selectQuery.getSelectColumnList().add("xsod_category.parent_code");
        selectQuery.getSelectColumnList().add("xsod_category.code");
        selectQuery.getSelectColumnList().add("xsod_category.name_01");
        selectQuery.getSelectColumnList().add("xsod_category.name_02");
        selectQuery.getSelectColumnList().add("xsod_category.merchandise_codes");
        selectQuery.getSelectColumnList().add("xsod_category.image_file_name");
        selectQuery.getSelectColumnList().add("xsod_category.priority");
        selectQuery.getSelectColumnList().addAll(tmpSelectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append("xsod_category");
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlSelectQuery selectQuery) {
        selectQuery.getOrderByList().add("xsod_category.set_id");
        selectQuery.getOrderByList().add("xsod_category.parent_code");
        selectQuery.getOrderByList().add("xsod_category.code");
    }
}

