/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.etc.model.EtcWord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XdtsWordXmlCreator {
    File destFile;

    public void createXml(Collection<EtcWord> wordCollection, File destFile) throws Exception {
        this.destFile = destFile;
        Document xmlDoc = this.createXml_L2(wordCollection);
        BcXmlUtil.output(xmlDoc, destFile, true, BcCharsetNames.UTF_8.value);
    }

    protected Document createXml_L2(Collection<EtcWord> wordCollection) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document xmlDoc = documentBuilder.newDocument();
        Element rootElem = xmlDoc.createElement("words");
        xmlDoc.appendChild(rootElem);
        Iterator<EtcWord> iterator = wordCollection.iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            if (++cnt % 100 == 0) {
                BcLogUtil.info("cnt=" + cnt);
            }
            EtcWord word = iterator.next();
            this.createXml_L3(rootElem, word);
        }
        return xmlDoc;
    }

    protected void createXml_L3(Element rootElem, EtcWord word) throws Exception {
        Element wordElem = BcXmlUtil.createElement(rootElem, "word");
        wordElem.setAttribute("code", word.code);
        if (!BcStringUtil.isEmpty(word.value)) {
            Element valueElem = BcXmlUtil.createElement(wordElem, "value");
            valueElem.setAttribute("lang", word.lang);
            BcXmlUtil.setTextValue(valueElem, word.value);
        }
        if (!BcStringUtil.isEmpty(word.note)) {
            Element noteElem = BcXmlUtil.createElement(wordElem, "note");
            BcXmlUtil.setTextValue(noteElem, word.note);
        }
    }
}

