/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.fx;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import jp.co.extreme.awt.AwtUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcDifference;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.module.tbcp.common.TbcpCsvComparator;
import jp.co.extreme.module.tbcp.fx.TbcpInstructionPane;
import jp.co.extreme.task.TskAbstractCallable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class TbcpCsvComparatorTask2
extends TskAbstractCallable {
    public Future future;
    public File file1;
    public File file2;
    public List<File> destFileList = new ArrayList<File>();
    public File resultCsvFile;
    public TbcpCondition condition;
    public TbcpInstructionPane instructionPane;

    TbcpCsvComparatorTask2() {
    }

    public Object taskProcess() throws Exception {
        InnerCsvComparator csvComparator = new InnerCsvComparator();
        csvComparator.setLogger(this.getLogger());
        csvComparator.condition = this.condition;
        csvComparator.compare(this.file1, this.file2);
        if (this.condition.fileOpen) {
            if (!BcCollectionUtil.isEmpty(this.destFileList)) {
                for (File file : this.destFileList) {
                    this.getLogger().info(String.format("Opening result file '%s'...", file.getName()));
                    AwtUtil.openFile(file);
                }
            }
            if (this.resultCsvFile != null) {
                this.getLogger().info(String.format("Opening result file '%s'...", this.resultCsvFile.getName()));
                AwtUtil.openFile(this.resultCsvFile);
            }
        }
        this.getLogger().info("Finished.");
        return null;
    }

    @Override
    protected void taskFinished() {
        this.instructionPane.executeButton.setDisable(false);
    }

    @Override
    protected void handleException(Throwable throwable) {
        this.instructionPane.executeButton.setDisable(false);
        this.instructionPane.handleException(throwable);
    }

    class InnerCsvComparator
    extends TbcpCsvComparator {
        InnerCsvComparator() {
        }

        @Override
        protected void writeWorkbook(XSSFWorkbook workbook, File destFile) throws Exception {
            super.writeWorkbook(workbook, destFile);
            TbcpCsvComparatorTask2.this.destFileList.add(destFile);
        }

        @Override
        protected void createResultCsv(Map<String, BcDifference> diffMap, File destFile) throws Exception {
            TbcpCsvComparatorTask2.this.resultCsvFile = destFile;
            super.createResultCsv(diffMap, destFile);
        }
    }
}

