/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.common;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.nlp.NlpNoun;

public final class TbcpUtil
extends BcLoggableObject {
    private TbcpUtil() {
    }

    public static List<NlpNoun> diff(String src1, String src2) throws Exception {
        char char1 = '\u0000';
        char char2 = '\u0000';
        int lengthMin = Math.min(src1.length(), src2.length());
        int lengthGap = Math.max(src1.length(), src2.length()) - lengthMin;
        ArrayList<NlpNoun> nounList = new ArrayList<NlpNoun>();
        NlpNoun noun = null;
        int i = 0;
        while (i < lengthMin) {
            char1 = src1.charAt(i);
            if (char1 == (char2 = src2.charAt(i))) {
                if (noun != null) {
                    noun.endIndex = i;
                    nounList.add(noun);
                    noun = null;
                }
            } else if (noun == null) {
                noun = new NlpNoun();
                noun.beginIndex = i;
                noun.endIndex = -1;
            }
            ++i;
        }
        if (noun != null) {
            nounList.add(noun);
        }
        if ((noun == null || noun != null && noun.endIndex >= 0) && lengthGap > 0) {
            noun = new NlpNoun();
            noun.beginIndex = lengthMin;
            noun.endIndex = -1;
            nounList.add(noun);
        }
        return nounList;
    }

    public static String substring(String src, NlpNoun noun) throws Exception {
        if (src.length() <= noun.beginIndex) {
            return "";
        }
        if (noun.endIndex >= 0) {
            return src.substring(noun.beginIndex, noun.endIndex);
        }
        return src.substring(noun.beginIndex);
    }

    public static TbcpCondition createCondition() {
        TbcpCondition condition = new TbcpCondition();
        condition.workbook = true;
        condition.csv = false;
        condition.comment = false;
        condition.fileOpen = true;
        return condition;
    }
}

