/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.server;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.impt.common.ImptImportUtil;
import jp.co.extreme.module.impt.common.ImptWords;
import jp.co.extreme.module.impt.model.ImptImportDefine;
import jp.co.extreme.module.impt.model.ImptMapper;
import jp.co.extreme.scf5.dao.ZScfDomainPropertyDAO;

public final class ImptServerUtil {
    private ImptServerUtil() {
    }

    public static ImptServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public String reformString(DtsSession dtsSession, ImptMapper mapper, String value1, int sharePropertyKey) throws Exception {
        String prefix;
        int length;
        if (BcStringUtil.isEmpty(value1)) {
            return null;
        }
        String value2 = value1;
        for (String key : mapper.repMap.keySet()) {
            String value = mapper.repMap.get(key);
            value2 = BcStringUtil.replace((CharSequence)value2, key.toString(), value).toString();
        }
        value2 = BcStringUtil.trim(value2);
        String exponentStr = mapper.props.getProperty("exponent");
        if (!BcStringUtil.isEmpty(exponentStr)) {
            int exponent = BcNumberUtil.parseInteger(exponentStr);
            BigDecimal dec = new BigDecimal(value1);
            dec = dec.movePointRight(exponent);
            value2 = dec.toString();
        }
        String propValue = mapper.props.getProperty("fractionDigits");
        if (!BcStringUtil.isEmpty(value2) && !BcStringUtil.isEmpty(propValue)) {
            int scale = BcNumberUtil.parseInt(propValue, 0);
            BigDecimal bigDec = BcNumberUtil.toBigDecimal(value2, scale);
            value2 = BcStringUtil.toString(bigDec);
        }
        if ((length = BcNumberUtil.parseInt(propValue = mapper.props.getProperty("length"), 0)) <= 0 && sharePropertyKey > 0) {
            propValue = ZScfDomainPropertyDAO.getInstance().getProperty(dtsSession, sharePropertyKey, "0");
            length = BcNumberUtil.parseInteger(propValue);
        }
        if (length > 0) {
            String prefix1 = mapper.props.getProperty("prefix");
            if (BcStringUtil.isEmpty(prefix1)) {
                prefix1 = "0";
            }
            value2 = BcStringUtil.fillPrefix(value2, length, prefix1.charAt(0));
        }
        if (!BcStringUtil.isEmpty(prefix = mapper.props.getProperty("prefix"))) {
            value2 = String.valueOf(prefix) + value2;
        }
        if (mapper.scriptEngine != null) {
            mapper.scriptEngine.put("value", value2);
            Object tmValue = null;
            tmValue = mapper.compiledScript != null ? mapper.compiledScript.eval() : mapper.scriptEngine.eval(mapper.script);
            value2 = tmValue != null ? tmValue.toString() : null;
        }
        return value2;
    }

    public String reformString(DtsSession dtsSession, ImptMapper mapper, List<String> valueList, int sharePropertyKey) throws Exception {
        if (mapper == null) {
            return null;
        }
        String value = null;
        if (mapper.mmdField.ordinalPosition >= 0) {
            value = valueList.get(mapper.mmdField.ordinalPosition);
            value = this.reformString(dtsSession, mapper, value, sharePropertyKey);
        } else {
            value = this.reformString(dtsSession, mapper, mapper.defaultValue, sharePropertyKey);
        }
        return value;
    }

    public String reformString(DtsSession dtsSession, ImptMapper mapper, List<String> valueList) throws Exception {
        return this.reformString(dtsSession, mapper, valueList, -1);
    }

    public Calendar perseTime(DtsSession dtsSession, ImptMapper mapper, List<String> valueList, String defaultParseFormat, ImptImportDefine importDefine) throws Exception {
        String srcStr = this.reformString(dtsSession, mapper, valueList, -1);
        return ImptImportUtil.getInstance().perseTime(mapper, srcStr, defaultParseFormat, importDefine);
    }

    public Calendar perseTime(DtsSession dtsSession, ImptMapper mapper, List<String> valueList, ImptImportDefine importDefine) throws Exception {
        return this.perseTime(dtsSession, mapper, valueList, null, importDefine);
    }

    public int getDataUpdateMode(DtsSession dtsSession, ImptImportDefine importDefine, String itemName, String defPropKey, int propertyKey) throws Exception {
        int updateMode = -1;
        String propValue = importDefine.props.getProperty(defPropKey);
        if (!BcStringUtil.isEmpty(propValue)) {
            try {
                updateMode = BcNumberUtil.parseInteger(propValue);
            }
            catch (Exception ex) {
                throw new Exception("\u30a4\u30f3\u30dd\u30fc\u30c8\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u306b\u304a\u3051\u308b '" + defPropKey + "' \u306e\u30c7\u30fc\u30bf\u66f4\u65b0\u30e2\u30fc\u30c9\u306e\u5024\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        }
        if (updateMode <= -1 && propertyKey > 0) {
            updateMode = BcNumberUtil.parseInt(ZScfDomainPropertyDAO.getInstance().getProperty(dtsSession, 201, propertyKey), -1);
        }
        if (updateMode >= 0) {
            ImptImportUtil.getInstance().nonLineNumberLog("\u30de\u30c3\u30d4\u30f3\u30b0\u540d '" + itemName + "' \u66f4\u65b0\u30e2\u30fc\u30c9='" + ImptWords.getInstance().toUpdateModeName(updateMode) + "'");
        }
        return updateMode;
    }

    public void setUpdateMode(DtsSession dtsSession, ImptMapper mapper, int propertyKey) throws Exception {
        if (mapper == null) {
            return;
        }
        if (mapper.updateMode <= -1 && propertyKey > 0) {
            mapper.updateMode = BcNumberUtil.parseInt(ZScfDomainPropertyDAO.getInstance().getProperty(dtsSession, 201, propertyKey), -1);
        }
        if (mapper.updateMode >= 0) {
            ImptImportUtil.getInstance().nonLineNumberLog("\u30de\u30c3\u30d4\u30f3\u30b0\u540d '" + mapper.name + "' \u66f4\u65b0\u30e2\u30fc\u30c9='" + ImptWords.getInstance().toUpdateModeName(mapper.updateMode) + "'");
        }
    }

    /* synthetic */ ImptServerUtil(ImptServerUtil imptServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final ImptServerUtil instance = new ImptServerUtil(null);

        private SingletonHolder() {
        }
    }
}

