/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.dcmn.rmo;

import java.io.InputStream;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.dcmn.dao.DcmnDocumentTemplateDAO;
import jp.co.extreme.module.dcmn.dao.DcmnFileResourceDAO;
import jp.co.extreme.module.dcmn.model.DcmnDocumentTemplate;
import jp.co.extreme.module.dcmn.server.DcmnServerUtil;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf5.model.ScfFileResource;
import jp.co.extreme.sql.model.SqlSelectQuery;

public class DcmnDocumentTemplateRMO
extends RmiAbstractRMO {
    public static final String METHOD_putDocumentTemplate = "putDocumentTemplate";
    public static final String METHOD_deleteDocumentTemplate = "deleteDocumentTemplate";
    public static final String METHOD_getDocumentTemplate = "getDocumentTemplate";
    public static final String METHOD_getDocumentTemplateList = "getDocumentTemplateList";
    public static final String METHOD_getFileResource = "getFileResource";
    public static final String METHOD_getDocForm = "getDocForm";

    public void putDocumentTemplate(RmiRmoArgument rmoArg) throws Exception {
        DcmnDocumentTemplate documentTemplate = (DcmnDocumentTemplate)rmoArg.getRequest().getData();
        String fileName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DcmnServerUtil.putDocumentTemplate(dtsSession, documentTemplate, fileName);
        rmoArg.getRespons().addData(documentTemplate);
    }

    public void deleteDocumentTemplate(RmiRmoArgument rmoArg) throws Exception {
        int documentTemplateId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        int cnt = DcmnDocumentTemplateDAO.getInstance().deleteDocumentTemplate(dtsSession, documentTemplateId);
        rmoArg.getRespons().addData(cnt);
    }

    public void getDocumentTemplate(RmiRmoArgument rmoArg) throws Exception {
        int documentTemplateId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DcmnDocumentTemplate documentTemplate = DcmnDocumentTemplateDAO.getInstance().getDocumentTemplate(dtsSession, documentTemplateId);
        String fileName = rmoArg.getRequest().getDataAsString();
        rmoArg.getRespons().addData(documentTemplate);
    }

    public void getDocumentTemplateList(RmiRmoArgument rmoArg) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.addSelectColumn("dcmn_document_template.id");
        selectQuery.addSelectColumn("dcmn_document_template.code");
        selectQuery.addSelectColumn("dcmn_document_template.name");
        selectQuery.addSelectColumn("dcmn_file_resource.id");
        selectQuery.addSelectColumn("dcmn_file_resource.file_name");
        selectQuery.setFromClause("dcmn_document_template__v1 AS dcmn_document_template LEFT JOIN dcmn_file_resource ON dcmn_file_resource.id = dcmn_document_template.file_resource_id");
        ScfSqlUtil.generalList(rmoArg, selectQuery);
    }

    public void getFileResource(RmiRmoArgument rmoArg) throws Exception {
        long fileResourceId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfFileResource fileResource = DcmnFileResourceDAO.getInstance().getFileResource(dtsSession, fileResourceId);
        rmoArg.getRespons().addData(fileResource);
    }

    public void getDocForm(RmiRmoArgument rmoArg) throws Exception {
        String fileName = rmoArg.getRequest().getDataAsString();
        String path = "docform/" + fileName;
        BcLogUtil.debug("path=" + path);
        InputStream is = this.getClass().getResourceAsStream("docform/" + fileName);
        byte[] bytes = BcStreamUtil.readWithClose(is);
        rmoArg.getRespons().addData(new String(bytes));
    }
}

