/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.itext;

import com.itextpdf.text.Document;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.doc.renderer.DcfTextRenderer;
import jp.co.extreme.doc.util.DcfBookUtil;
import jp.co.extreme.doc.util.DcfPageReader;
import jp.co.extreme.html.ruby.HtmlRubyParser;
import jp.co.extreme.itext.ItextGraphics2D;
import jp.co.extreme.itext.ItextUtil;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfPageFormat;

public class ItextPdfConverter
extends BcLoggableObject {
    protected DcfPageReader pageReader;
    protected File tempDir;
    protected DcfPageFormat pageFormat;
    protected Rectangle pageSize;
    protected Document document;
    public PdfWriter pdfwriter;
    protected ArrayList<File> destFileList;
    protected DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();
    protected HtmlRubyParser rubyHtmlParser = new HtmlRubyParser();
    protected DcfTextRenderer textRenderer = new DcfTextRenderer(null);

    public ItextPdfConverter() throws Exception {
        this.setLogger(BcLogUtil.getDefaultLogger());
    }

    public List<File> createPdf(DcfPageReader pageReader, File tempDir) throws Exception {
        this.pageReader = pageReader;
        this.tempDir = tempDir;
        this.destFileList = new ArrayList();
        if (pageReader.getPageCount() <= 0) {
            return this.destFileList;
        }
        BcFileUtil.mkdirs(tempDir, new FileAttribute[0]);
        DcfPageFormat prePageFormat = null;
        this.getLogger().info("\u30d6\u30c3\u30af\u30da\u30fc\u30b8\u6570=" + pageReader.getPageCount());
        int i = 0;
        while (i < pageReader.getPageCount()) {
            DcfPage dcfPage = pageReader.getPage(i);
            DcfPageFormat pageFormat = dcfPage.getPageFormat();
            boolean newPdf = true;
            if (i > 0) {
                newPdf = !DcfBookUtil.isSameSize(prePageFormat, pageFormat);
            }
            this.drawPage(dcfPage, i + 1, newPdf);
            prePageFormat = pageFormat;
            ++i;
        }
        if (this.document != null) {
            try {
                this.document.close();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        return this.destFileList;
    }

    public void drawPage(DcfPage dcfPage, int pageNo, boolean newPdf) throws Exception {
        if (newPdf) {
            if (this.pdfwriter != null) {
                this.pdfwriter.close();
                this.document.close();
            }
            this.pageFormat = dcfPage.getPageFormat();
            this.pageSize = ItextUtil.toRectangle(this.pageFormat.getWidth(), this.pageFormat.getHeight());
            this.document = new Document(this.pageSize, 0.0f, 0.0f, 0.0f, 0.0f);
            File destFile = File.createTempFile("temp_", ".pdf", this.tempDir);
            this.getLogger().info("\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9=" + destFile.getPath());
            this.destFileList.add(destFile);
            FileOutputStream os = new FileOutputStream(destFile);
            this.pdfwriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            this.pdfwriter.setPdfVersion('7');
            this.pdfwriter.setPageEvent((PdfPageEvent)new PdfPageEventHelper(){

                public void onStartPage(PdfWriter writer, Document document) {
                }

                public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
                }

                public void onSection(PdfWriter writer, Document document, float paragraphPosition, int depth, Paragraph title) {
                }

                public void onEndPage(PdfWriter writer, Document document) {
                }
            });
            this.document.open();
            if (!BcStringUtil.isEmpty(this.pageReader.getTitle())) {
                this.document.addTitle(this.pageReader.getTitle());
            }
            if (!BcStringUtil.isEmpty(this.pageReader.getAuthor())) {
                this.document.addAuthor(this.pageReader.getAuthor());
            }
            this.document.addHeader("Expires", "0");
            this.document.addKeywords("iText,pdf");
            this.document.addCreator("Extreme Java program");
        } else if (pageNo > 1) {
            this.document.newPage();
        }
        this.drawPage(dcfPage, 0.0, 0.0);
    }

    protected void drawPage(DcfPage dcfPage, double osX, double osY) throws Exception {
        PdfContentByte pdfContentByte = this.pdfwriter.getDirectContent();
        ItextGraphics2D g2d = new ItextGraphics2D(pdfContentByte, this.pageSize.getWidth(), this.pageSize.getHeight(), dcfPage.getPageFormat());
        this.shapeRenderer.drawPage((Graphics2D)((Object)g2d), osX, osY, dcfPage);
        g2d.dispose();
    }
}

