/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.renderer;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import jp.co.extreme.doc.barcode.renderer.DcfItfRenderer;
import jp.co.extreme.doc.barcode.renderer.DcfNw7Renderer;
import jp.co.extreme.doc.barcode.renderer.DcfZxingRenderer;
import jp.co.extreme.doc.util.DcfConstants;
import nlc.lib.barcode.DcfAbstractBarcodeContext;
import nlc.lib.barcode.DcfBarcodeContext;
import nlc.lib.barcode.DcfBarcodeRenderer;
import nlc.lib.barcode.DcfDataMatrixContext;
import nlc.lib.barcode.DcfItfContext;
import nlc.lib.barcode.DcfNw7Context;
import nlc.lib.doc.shape.barcode.DcfAbstractBarcodeShape;
import nlc.lib.doc.shape.barcode.DcfDataMatrixShape;

public final class DcfShapeRenderingUtil {
    private DcfShapeRenderingUtil() {
    }

    public static double getHeight(TextLayout textLayout) throws Exception {
        double height = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return height;
    }

    public static Stroke createStroke(double lineWidth, String lineType) throws Exception {
        int cap = 0;
        int joinType = 0;
        double joinMiterLimit = 1.0;
        if (joinMiterLimit < 1.0) {
            joinMiterLimit = 1.0;
        }
        double dashDraw = 2.0;
        double dashSpace = 0.0;
        if (DcfConstants.LineType.dotted01.code.equals(lineType)) {
            dashSpace = 2.0;
        }
        float[] dashAttr = new float[]{(float)dashDraw, (float)dashSpace};
        double dashPhase = 0.0;
        BasicStroke stroke = new BasicStroke((float)lineWidth, cap, joinType, (float)joinMiterLimit, dashAttr, (float)dashPhase);
        return stroke;
    }

    public static DcfBarcodeRenderer createBarcodeRenderer(DcfAbstractBarcodeShape barcodeShape) throws Exception {
        DcfBarcodeRenderer barcodeRenderer = null;
        DcfAbstractBarcodeContext barcodeContext = null;
        barcodeContext = barcodeShape.getClass().getSimpleName().equals("DcfItfShape") ? new DcfItfContext() : barcodeShape.getBarcodeContext();
        if (DcfItfContext.class.isAssignableFrom(barcodeContext.getClass())) {
            DcfItfContext itfContext = (DcfItfContext)barcodeContext;
            barcodeRenderer = new DcfItfRenderer(itfContext);
        } else if (DcfNw7Context.class.isAssignableFrom(barcodeContext.getClass())) {
            DcfNw7Context nw7Context = (DcfNw7Context)barcodeContext;
            barcodeRenderer = new DcfNw7Renderer(nw7Context);
        } else if (DcfDataMatrixContext.class.isAssignableFrom(barcodeContext.getClass())) {
            int height;
            DcfDataMatrixShape dataMatrixShape = (DcfDataMatrixShape)barcodeShape;
            int width = (int)dataMatrixShape.getRectangle().width;
            if (width <= 0) {
                width = 14;
            }
            if ((height = (int)dataMatrixShape.getRectangle().height) <= 0) {
                height = 14;
            }
            barcodeRenderer = new DcfZxingRenderer(width, height, dataMatrixShape.doFit, dataMatrixShape.angle);
        } else if (DcfBarcodeContext.class.isAssignableFrom(barcodeContext.getClass())) {
            DcfBarcodeContext barcodeContext2 = (DcfBarcodeContext)barcodeContext;
            barcodeRenderer = barcodeContext2;
        } else {
            throw new Exception(" Not suppoted class. " + barcodeShape.getClass().getName());
        }
        return barcodeRenderer;
    }
}

