/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcReaderThreadCash;

public class BcProcessExecutor
extends BcLoggableObject {
    String charsetName;

    public BcProcessExecutor() {
        this.charsetName = BcCharsetNames.UTF_8.value;
    }

    public BcProcessResult execute(String ... args) throws Exception {
        BcProcessResult processResult = new BcProcessResult();
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processResult.startNanos = System.nanoTime();
        Process process = processBuilder.start();
        BufferedReader ibf = new BufferedReader(new InputStreamReader(process.getInputStream(), this.charsetName));
        BcReaderThreadCash inputReaderThread = new BcReaderThreadCash(ibf, System.out);
        inputReaderThread.start();
        BufferedReader ebf = new BufferedReader(new InputStreamReader(process.getErrorStream(), this.charsetName));
        BcReaderThreadCash errorReaderThread = new BcReaderThreadCash(ebf, System.err);
        errorReaderThread.start();
        process.getOutputStream().close();
        process.waitFor();
        inputReaderThread.join();
        errorReaderThread.join();
        process.destroy();
        processResult.endNanos = System.nanoTime();
        processResult.elapsNanos = processResult.endNanos - processResult.startNanos;
        processResult.elapsMillis = processResult.elapsNanos / 1000L / 1000L;
        processResult.exitValue = process.exitValue();
        if (!BcCollectionUtil.isEmpty(inputReaderThread.lineList)) {
            processResult.out = BcStringUtil.marge(inputReaderThread.lineList);
        }
        if (!BcCollectionUtil.isEmpty(errorReaderThread.lineList)) {
            processResult.out = BcStringUtil.marge(errorReaderThread.lineList);
        }
        return processResult;
    }

    public BcProcessResult execute(List<String> argList) throws Exception {
        String[] args = argList.toArray(new String[0]);
        return this.execute(args);
    }

    public BcProcessResult execute(String command, List<String> argList) throws Exception {
        argList.add(0, command);
        return this.execute(argList);
    }

    public static class BcProcessResult {
        public Process process;
        public int exitValue;
        public long startNanos;
        public long endNanos;
        public long elapsNanos;
        public long elapsMillis;
        public String out;
        public String err;
    }
}

