/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.log.BcLoggerFactory;
import jp.co.extreme.base.runtime.BcRuntimeUtil;

public final class BcLogUtil {
    public static final String ROOT_LOGGER_NAME = "";
    public static Map<String, BcLogger> loggerMap = new ConcurrentHashMap<String, BcLogger>();
    private static BcLogger loggerDefault;
    public static final BcLogConstants.LogLevel logLevelDefault;
    public static BcLoggerFactory loggerFactory;

    static {
        logLevelDefault = BcLogConstants.LogLevel.INFO;
        try {
            String className = "jp.co.extreme.base.log.BcLoggerFactoryJul";
            System.out.println("loggerFactoryClass=" + className);
            Class<?> loggerFactoryClass = Class.forName(className);
            loggerFactory = (BcLoggerFactory)loggerFactoryClass.newInstance();
            BcLogger logger = BcLogUtil.createLogger(ROOT_LOGGER_NAME, false, true);
            logger.setLogLevel(logLevelDefault);
            BcLogUtil.setDefaultLogger(logger);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private BcLogUtil() {
    }

    public static synchronized BcLogger createLogger(String loggerName, boolean isAdditive, boolean consoleEnabled) throws Exception {
        BcLogger logger = loggerMap.get(loggerName);
        if (logger == null) {
            logger = loggerFactory.createLogger(loggerName, isAdditive, consoleEnabled);
            loggerMap.put(loggerName, logger);
            if (BcLogUtil.getDefaultLogger() != null) {
                logger.setLogLevel(BcLogUtil.getDefaultLogger().getLogLevel());
            } else {
                logger.setLogLevel(logLevelDefault);
            }
        }
        return logger;
    }

    public static void addFileFileHandler(BcLogger logger, File destFile) throws Exception {
        loggerFactory.addFileFileHandler(logger, destFile);
    }

    public static BcLogger getLogger(String loggerName) {
        BcLogger logger = loggerMap.get(loggerName);
        return logger;
    }

    public static BcLogger getDefaultLogger() {
        return loggerDefault;
    }

    public static void setDefaultLogger(BcLogger logger) {
        loggerDefault = logger;
    }

    public static void fatal(Object log) {
        loggerDefault.fatal(log);
    }

    public static void error(Object log) {
        loggerDefault.error(log);
    }

    public static void warning(Object log) {
        loggerDefault.warning(log);
    }

    public static void info(Object log) {
        loggerDefault.info(log);
    }

    public static void debug(Object log) {
        loggerDefault.debug(log);
    }

    public static void trace(Object log) {
        loggerDefault.trace(log);
    }

    public static String getStackTrace(Throwable throwable) {
        String stackTrace;
        block5: {
            StringWriter sw = null;
            PrintWriter pw = null;
            stackTrace = null;
            try {
                try {
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.getBuffer().toString();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    BcStreamUtil.close(sw);
                    BcStreamUtil.close(pw);
                    break block5;
                }
            }
            catch (Throwable throwable2) {
                BcStreamUtil.close(sw);
                BcStreamUtil.close(pw);
                throw throwable2;
            }
            BcStreamUtil.close(sw);
            BcStreamUtil.close(pw);
        }
        return stackTrace;
    }

    public static String convertMessage(Object message) {
        if (message == null) {
            return null;
        }
        String newMessage = null;
        if (Throwable.class.isAssignableFrom(message.getClass())) {
            Throwable throwable = (Throwable)message;
            newMessage = BcLogUtil.getStackTrace(throwable);
        } else {
            newMessage = message.toString();
        }
        return newMessage;
    }

    public static String createLabel(String title, String charStr, int pre, int totalLength) {
        StringBuilder sb = new StringBuilder();
        sb.append(BcStringUtil.fill(charStr, pre));
        sb.append(" ");
        sb.append(title);
        sb.append(" ");
        if (sb.length() < totalLength) {
            sb.append(BcStringUtil.fill(charStr, totalLength - sb.length()));
        }
        return sb.toString();
    }

    public static void setupDefault() {
        File destDir = new File(BcRuntimeUtil.getUserDir(), "log");
        File destFile = new File(destDir, "default.log");
        BcLogger logger = BcLogUtil.getDefaultLogger();
        try {
            BcLogUtil.addFileFileHandler(logger, destFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static BcLogConstants.LogLevel parseLogLevel(String value, BcLogConstants.LogLevel logLevelDefault) throws Exception {
        BcLogConstants.LogLevel logLevel = null;
        if (BcStringUtil.isEmpty(value)) {
            logLevel = logLevelDefault;
        } else {
            logLevel = BcLangUtil.getEnumByName(BcLogConstants.LogLevel.class, value, true);
            if (logLevel == null) {
                String msg = String.format("Log level cannot be parsed. value='%s'", value);
                throw new Exception(msg);
            }
        }
        return logLevel;
    }
}

