/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.dict;

import com.atilika.kuromoji.dict.DictionaryEntryBase;
import java.util.List;

public class GenericDictionaryEntry
extends DictionaryEntryBase {
    private final String[] partOfSpeechFeatures;
    private final String[] otherFeatures;

    public GenericDictionaryEntry(Builder builder) {
        super(builder.surface, builder.leftId, builder.rightId, builder.wordCost);
        this.partOfSpeechFeatures = builder.partOfSpeechFeatures;
        this.otherFeatures = builder.otherFeatures;
    }

    public String[] getPartOfSpeechFeatures() {
        return this.partOfSpeechFeatures;
    }

    public String[] getOtherFeatures() {
        return this.otherFeatures;
    }

    public static class Builder {
        private String surface;
        private short leftId;
        private short rightId;
        private short wordCost;
        private String[] partOfSpeechFeatures;
        private String[] otherFeatures;

        public Builder surface(String surface) {
            this.surface = surface;
            return this;
        }

        public Builder leftId(short leftId) {
            this.leftId = leftId;
            return this;
        }

        public Builder rightId(short rightId) {
            this.rightId = rightId;
            return this;
        }

        public Builder wordCost(short wordCost) {
            this.wordCost = wordCost;
            return this;
        }

        public Builder partOfSpeech(List<String> pos) {
            this.partOfSpeechFeatures = pos.toArray(new String[0]);
            return this;
        }

        public Builder features(List<String> features) {
            this.otherFeatures = features.toArray(new String[0]);
            return this;
        }

        public GenericDictionaryEntry build() {
            return new GenericDictionaryEntry(this);
        }
    }
}

