/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.compile.CharacterDefinitionsCompiler;
import com.atilika.kuromoji.compile.ConnectionCostsCompiler;
import com.atilika.kuromoji.compile.FSTCompiler;
import com.atilika.kuromoji.compile.ProgressLog;
import com.atilika.kuromoji.compile.TokenInfoDictionaryCompilerBase;
import com.atilika.kuromoji.compile.UnknownDictionaryCompiler;
import com.atilika.kuromoji.fst.FST;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public abstract class DictionaryCompilerBase {
    public void build(String inputDirname, String outputDirname, String encoding) throws IOException {
        File outputDir = new File(outputDirname);
        outputDir.mkdirs();
        this.buildTokenInfoDictionary(inputDirname, outputDirname, encoding);
        this.buildUnknownWordDictionary(inputDirname, outputDirname, encoding);
        this.buildConnectionCosts(inputDirname, outputDirname);
    }

    private void buildTokenInfoDictionary(String inputDirname, String outputDirname, String encoding) throws IOException {
        ProgressLog.begin("compiling tokeninfo dict");
        TokenInfoDictionaryCompilerBase tokenInfoCompiler = this.getTokenInfoDictionaryCompiler(encoding);
        ProgressLog.println("analyzing dictionary features");
        tokenInfoCompiler.analyzeTokenInfo(tokenInfoCompiler.combinedSequentialFileInputStream(new File(inputDirname)));
        ProgressLog.println("reading tokeninfo");
        tokenInfoCompiler.readTokenInfo(tokenInfoCompiler.combinedSequentialFileInputStream(new File(inputDirname)));
        tokenInfoCompiler.compile();
        List<String> surfaces = tokenInfoCompiler.getSurfaces();
        ProgressLog.begin("compiling fst");
        FSTCompiler fstCompiler = new FSTCompiler(new BufferedOutputStream(new FileOutputStream(new File(outputDirname, "fst.bin"))), surfaces);
        fstCompiler.compile();
        ProgressLog.println("validating saved fst");
        FST fst = new FST(new BufferedInputStream(new FileInputStream(new File(outputDirname, "fst.bin"))));
        for (String surface : surfaces) {
            if (fst.lookup(surface) >= 0) continue;
            ProgressLog.println("failed to look up [" + surface + "]");
        }
        ProgressLog.end();
        ProgressLog.begin("processing target map");
        for (int i = 0; i < surfaces.size(); ++i) {
            int id = fst.lookup(surfaces.get(i));
            assert (id > 0);
            tokenInfoCompiler.addMapping(id, i);
        }
        tokenInfoCompiler.write(outputDirname);
        ProgressLog.end();
        ProgressLog.end();
    }

    protected abstract TokenInfoDictionaryCompilerBase getTokenInfoDictionaryCompiler(String var1);

    protected void buildUnknownWordDictionary(String inputDirname, String outputDirname, String encoding) throws IOException {
        ProgressLog.begin("compiling unknown word dict");
        CharacterDefinitionsCompiler charDefCompiler = new CharacterDefinitionsCompiler(new BufferedOutputStream(new FileOutputStream(new File(outputDirname, "characterDefinitions.bin"))));
        charDefCompiler.readCharacterDefinition(new BufferedInputStream(new FileInputStream(new File(inputDirname, "char.def"))), encoding);
        charDefCompiler.compile();
        UnknownDictionaryCompiler unkDefCompiler = new UnknownDictionaryCompiler(charDefCompiler.makeCharacterCategoryMap(), new FileOutputStream(new File(outputDirname, "unknownDictionary.bin")));
        unkDefCompiler.readUnknownDefinition(new BufferedInputStream(new FileInputStream(new File(inputDirname, "unk.def"))), encoding);
        unkDefCompiler.compile();
        ProgressLog.end();
    }

    private void buildConnectionCosts(String inputDirname, String outputDirname) throws IOException {
        ProgressLog.begin("compiling connection costs");
        ConnectionCostsCompiler connectionCostsCompiler = new ConnectionCostsCompiler(new FileOutputStream(new File(outputDirname, "connectionCosts.bin")));
        connectionCostsCompiler.readCosts(new FileInputStream(new File(inputDirname, "matrix.def")));
        connectionCostsCompiler.compile();
        ProgressLog.end();
    }

    protected void build(String[] args) throws IOException {
        String inputDirname = args[0];
        String outputDirname = args[1];
        String inputEncoding = args[2];
        ProgressLog.println("dictionary compiler");
        ProgressLog.println("");
        ProgressLog.println("input directory: " + inputDirname);
        ProgressLog.println("output directory: " + outputDirname);
        ProgressLog.println("input encoding: " + inputEncoding);
        ProgressLog.println("");
        this.build(inputDirname, outputDirname, inputEncoding);
    }
}

