/*
 * Decompiled with CFR 0.152.
 */
package opennlp.morfologik.cmdline.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Properties;
import morfologik.stemming.DictionaryMetadata;
import opennlp.morfologik.cmdline.builder.XMLDictionaryToTableParams;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.postag.POSDictionary;

public class XMLDictionaryToTableTool
extends BasicCmdLineTool {
    private String SEPARATOR;

    public String getShortDescription() {
        return "reads an OpenNLP XML tag dictionary and outputs it in a tabular file";
    }

    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    public void run(String[] args) {
        POSDictionary tagDictionary;
        Params params = (Params)this.validateAndParseParams(args, Params.class);
        File dictInFile = params.getInputFile();
        File dictOutFile = params.getOutputFile();
        Charset encoding = params.getEncoding();
        this.SEPARATOR = params.getSeparator();
        CmdLineUtil.checkInputFile((String)"dictionary input file", (File)dictInFile);
        CmdLineUtil.checkOutputFile((String)"dictionary output file", (File)dictOutFile);
        try {
            tagDictionary = POSDictionary.create((InputStream)new FileInputStream(dictInFile));
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "Error while loading XML POS Dictionay: " + e.getMessage(), (Throwable)e);
        }
        Iterator iterator = tagDictionary.iterator();
        try (BufferedWriter writer = Files.newBufferedWriter(dictOutFile.toPath(), encoding, new OpenOption[0]);){
            while (iterator.hasNext()) {
                String word = (String)iterator.next();
                for (String tag : tagDictionary.getTags(word)) {
                    if (!this.valid(word, tag)) continue;
                    String entry = this.createEntry(word, tag);
                    writer.write(entry);
                    writer.newLine();
                }
            }
            writer.close();
            System.out.println("Created dictionary: " + dictOutFile.toPath());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "Error while writing output: " + e.getMessage(), (Throwable)e);
        }
        Properties info = new Properties();
        info.setProperty("fsa.dict.separator", this.SEPARATOR);
        info.setProperty("fsa.dict.encoding", params.getEncoding().name());
        info.setProperty("fsa.dict.encoder", params.getEncoder());
        Path metaPath = DictionaryMetadata.getExpectedMetadataLocation((Path)dictOutFile.toPath());
        try {
            info.store(Files.newOutputStream(metaPath, new OpenOption[0]), "Info file for FSA Morfologik dictionary.");
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "Error while writing metadata output: " + e.getMessage(), (Throwable)e);
        }
        System.out.println("Created metadata: " + dictOutFile.toPath());
    }

    private boolean valid(String word, String tag) {
        if (word.contains(this.SEPARATOR) || tag.contains(this.SEPARATOR)) {
            System.out.println("Warn: invalid entry because contains separator - word: " + word + " tag: " + tag);
            return false;
        }
        return true;
    }

    private String createEntry(String word, String tag) {
        return "" + this.SEPARATOR + word + this.SEPARATOR + tag;
    }

    static interface Params
    extends XMLDictionaryToTableParams {
    }
}

