/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing.lookAndFeel;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.Color;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.UIManager;

public class SwgLafNimrodUtil {
    public static final String THEME_suffix = "";

    public static NimRODTheme iniCustomColors(NimRODTheme nimRODTheme, String selection, String background, String p1, String p2, String p3, String s1, String s2, String s3, String w, String b, String menuOpacity, String frameOpacity) {
        if (selection != null) {
            nimRODTheme.setPrimary(Color.decode(selection));
        }
        if (background != null) {
            nimRODTheme.setSecondary(Color.decode(background));
        }
        if (p1 != null) {
            nimRODTheme.setPrimary1(Color.decode(p1));
        }
        if (p2 != null) {
            nimRODTheme.setPrimary2(Color.decode(p2));
        }
        if (p3 != null) {
            nimRODTheme.setPrimary3(Color.decode(p3));
        }
        if (s1 != null) {
            nimRODTheme.setSecondary1(Color.decode(s1));
        }
        if (s2 != null) {
            nimRODTheme.setSecondary2(Color.decode(s2));
        }
        if (s3 != null) {
            nimRODTheme.setSecondary3(Color.decode(s3));
        }
        if (w != null) {
            nimRODTheme.setWhite(Color.decode(w));
        }
        if (b != null) {
            nimRODTheme.setBlack(Color.decode(b));
        }
        if (menuOpacity != null) {
            nimRODTheme.setMenuOpacity(Integer.parseInt(menuOpacity));
        }
        if (frameOpacity != null) {
            nimRODTheme.setFrameOpacity(Integer.parseInt(frameOpacity));
        }
        return nimRODTheme;
    }

    public static NimRODTheme createTheme(InputStream is) throws Exception {
        Properties props = new Properties();
        props.load(is);
        String selection = props.getProperty("nimrodlf.selection");
        String background = props.getProperty("nimrodlf.background");
        String p1 = props.getProperty("nimrodlf.p1");
        String p2 = props.getProperty("nimrodlf.p2");
        String p3 = props.getProperty("nimrodlf.p3");
        String s1 = props.getProperty("nimrodlf.s1");
        String s2 = props.getProperty("nimrodlf.s2");
        String s3 = props.getProperty("nimrodlf.s3");
        String w = props.getProperty("nimrodlf.w");
        String b = props.getProperty("nimrodlf.b");
        String menuOpacity = props.getProperty("nimrodlf.menuOpacity");
        String frameOpacity = props.getProperty("nimrodlf.frameOpacity");
        NimRODTheme nimRODTheme = new NimRODTheme();
        nimRODTheme = SwgLafNimrodUtil.iniCustomColors(nimRODTheme, selection, background, p1, p2, p3, s1, s2, s3, w, b, menuOpacity, frameOpacity);
        return nimRODTheme;
    }

    public static NimRODTheme createTheme(String themeName) throws Exception {
        String fileName = String.valueOf(themeName.replace(THEME_suffix, THEME_suffix)) + ".theme";
        InputStream is = NimRODTheme.class.getResourceAsStream("theme/" + fileName);
        return SwgLafNimrodUtil.createTheme(is);
    }

    public static void setTheme(NimRODTheme nimRODTheme) throws Exception {
        NimRODLookAndFeel nimRODLookAndFeel = new NimRODLookAndFeel();
        NimRODLookAndFeel.setCurrentTheme(nimRODTheme);
        UIManager.setLookAndFeel(nimRODLookAndFeel);
    }

    public static void setTheme(String themeName) throws Exception {
        NimRODTheme nimRODTheme = SwgLafNimrodUtil.createTheme(themeName);
        SwgLafNimrodUtil.setTheme(nimRODTheme);
    }

    public static enum ThemeNames {
        Night,
        DarkTabaco,
        LightTabaco,
        Burdeos,
        Snow,
        DarkGray_Blue_01,
        DarkGray_Green_01,
        DarkGray_Purple_01,
        DarkGray_White_01,
        DarkBlue_Blue_01,
        DarkGren_Green_01;

    }
}

