/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql.context;

import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.context.SqlContext;

public class SqlContext_HSQLDB
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "org.hsqldb.jdbcDriver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"org.hsqldb.jdbcDriver"};

    public SqlContext_HSQLDB(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public boolean isSupported(SqlContext.Function function) {
        switch (function) {
            case selectForUpdate: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy-MM-dd";
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }
}

