/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SplashScreen;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import jp.co.extreme.app.common.ApApplicationEvent;
import jp.co.extreme.app.common.ApApplicationEventHandler;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.swing.SwgImagePanel;
import jp.co.extreme.swing.SwgUtil;

public class IswgSplashScreen
implements ApApplicationEventHandler {
    protected int baseWidth = 400;
    protected int baseHeight = 260;
    protected int labelHeigt = 14;
    protected Graphics gp;
    protected Color labelBgColor = new Color(220, 220, 220);
    protected Color labelFgColor = Color.DARK_GRAY;
    protected Font font = new Font("SansSerif", 0, 9);
    protected JFrame frame;

    @Override
    public void actionPerformed(ApApplicationEvent ev) throws Exception {
        if (ev.type == 11) {
            this.setupStarted();
        } else if (ev.type == 41) {
            String text = BcStringUtil.toStringNotNull(ev.value);
            if (!BcStringUtil.isEmpty(text)) {
                this.drawText(text);
            }
        } else if (ev.type == 12) {
            this.setupFinished();
        }
    }

    public void setupStarted() throws Exception {
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen == null) {
            BufferedImage image = new BufferedImage(this.baseWidth, this.baseWidth, 5);
            this.gp = image.getGraphics();
            this.gp.setColor(Color.LIGHT_GRAY);
            this.gp.fillRect(0, 0, image.getWidth(), image.getHeight());
            SwgImagePanel imagePanel = new SwgImagePanel();
            imagePanel.setImage(image);
            this.frame = new JFrame();
            this.frame.setUndecorated(true);
            this.frame.setBackground(new Color(0, true));
            this.frame.getContentPane().add((Component)imagePanel, "Center");
            this.frame.setResizable(false);
            SwgUtil.setCenter(this.frame, this.baseWidth, this.baseHeight);
            this.frame.setVisible(true);
        } else {
            this.baseWidth = splashScreen.getBounds().width;
            this.baseHeight = splashScreen.getBounds().height;
            this.gp = splashScreen.createGraphics();
        }
        String msg = "Initializing...";
        this.drawText(msg);
    }

    public void setupFinished() throws Exception {
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            splashScreen.close();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    protected void drawText(String text) throws Exception {
        SplashScreen splashScreen;
        this.gp.setColor(this.labelBgColor);
        this.gp.fillRect(0, this.baseHeight - this.labelHeigt, this.baseWidth, this.labelHeigt);
        this.gp.setFont(this.font);
        this.gp.setColor(this.labelFgColor);
        FontMetrics fontMetrics = this.gp.getFontMetrics(this.font);
        Dimension dim = new Dimension(fontMetrics.stringWidth(text), fontMetrics.getHeight());
        int x = 0;
        if (this.baseWidth > dim.width) {
            x = (this.baseWidth - dim.width) / 2;
        }
        int y = this.baseHeight - 4;
        if (!BcStringUtil.isEmpty(text)) {
            this.gp.drawString(text, x, y);
        }
        if ((splashScreen = SplashScreen.getSplashScreen()) != null) {
            splashScreen.update();
        }
    }
}

