/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.client;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsConnectionManagerImpl;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.lib.rmi.client.RmiAgentStandAlone;
import jp.co.extreme.rmi.client.RmiLocalAgent;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf.datasource.ScfDatasourceConfigParser;
import jp.co.extreme.scf3.stub.ScfDatabaseStub;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlUtil;

public final class ScfStandAloneHelper
extends BcLoggableObject {
    RmiAgentStandAlone agentStandAlone;

    private ScfStandAloneHelper() {
    }

    public static ScfStandAloneHelper getInstance() {
        return SingletonHolder.instance;
    }

    public RmiLocalAgent getLocalAgent(RmiLocalAgent localAgent, boolean isLocal) throws Exception {
        if (isLocal) {
            if (localAgent instanceof RmiAgentStandAlone) {
                return localAgent;
            }
            this.getLogger().info("\u30b9\u30bf\u30f3\u30c9\u30a2\u30ed\u30f3\u7528\u306e\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f\u3002");
            return this.getAgentStandAlon();
        }
        return localAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RmiAgentStandAlone getAgentStandAlon() throws Exception {
        if (this.agentStandAlone != null) {
            return this.agentStandAlone;
        }
        RmiLocalAgent localAgent = ScfClientContainer.getInstance().getAgent();
        if (localAgent instanceof RmiAgentStandAlone) {
            return (RmiAgentStandAlone)localAgent;
        }
        ScfStandAloneHelper scfStandAloneHelper = this;
        synchronized (scfStandAloneHelper) {
            if (this.agentStandAlone != null) {
                return this.agentStandAlone;
            }
            this.setupSessionFactory("main");
            this.agentStandAlone = new RmiAgentStandAlone();
        }
        return this.agentStandAlone;
    }

    public void setupSessionFactory(String datasourceName) throws Exception {
        DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        if (sessionFactory != null) {
            String msg = String.format("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u540d '{s}' \u306e DtsSessionFactory \u306f\u767b\u9332\u6e08\u3067\u3059\u3002", datasourceName);
            this.getLogger().warning(msg);
            return;
        }
        RmiLocalAgent agent = ScfClientContainer.getInstance().getAgent();
        Properties dtsProps = ScfDatabaseStub.getInstance().getDatasourceProperties(agent, datasourceName);
        if (dtsProps == null) {
            String msg = String.format("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u540d '{s}' \u306e\u8a2d\u5b9a\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", datasourceName);
            this.getLogger().warning(msg);
            return;
        }
        String driverClassName = dtsProps.getProperty(SqlConstants.DataSourceProperty.driver.name());
        String dtsUrl = dtsProps.getProperty(SqlConstants.DataSourceProperty.url.name());
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        connectionManager.setMinIdle(0);
        connectionManager.setMaxIdle(0);
        connectionManager.setMaxConnection(5);
        ((DtsConnectionManager)connectionManager).setup(SqlUtil.createDriver(driverClassName), dtsUrl, dtsProps);
        sessionFactory = new DtsSessionFactory(datasourceName, connectionManager);
        ScfDatasourceConfigParser.setupLogger(sessionFactory, ApApplication.getInstance().getLogDir());
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)sessionFactory.wordManager;
        Object[] res = ScfDatabaseStub.getInstance().getMmdFieldMap(agent, datasourceName);
        sessionFactory.mmdFieldMap = (Map)res[0];
        wordManager.wordMap = (Map)res[1];
        wordManager.langCodeList = (List)res[2];
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(sessionFactory);
    }

    /* synthetic */ ScfStandAloneHelper(ScfStandAloneHelper scfStandAloneHelper) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfStandAloneHelper instance = new ScfStandAloneHelper(null);

        private SingletonHolder() {
        }
    }
}

