/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.server;

import java.io.File;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.app.common.ApApplicationSetup;
import jp.co.extreme.app.common.ApLogUtil;
import jp.co.extreme.app.common.ApShutdownManager;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcArgumentUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.scf.rmi.server.RmiServerModule;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf.server.ScfServerShutdownTask;
import jp.co.extreme.scf.util.ScfSetupUtil;
import org.w3c.dom.Document;

public class ScfServerSetup
extends BcLoggableObject
implements ApApplicationSetup {
    @Override
    public void setup(ApApplication application) throws Exception {
        String serverCofigPath;
        File file;
        this.getLogger().info(ApLogUtil.serverModeLog(application));
        String vFilePath = BcArgumentUtil.getArgumentValue(application.getMainArguments(), "-svcfg");
        if (BcStringUtil.isEmpty(vFilePath)) {
            vFilePath = "${APP}config/server.xml";
        }
        if ((file = new File(serverCofigPath = application.toReal(vFilePath))).exists()) {
            Document dom = BcXmlUtil.createDocument(file);
            ScfServerContainer serverContainer = ScfServerContainer.getInstance();
            serverContainer.setConfig(dom);
        }
        this.setupCommon(application);
    }

    public void setupCommon(ApApplication application) throws Exception {
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        RmiServerModule rmiServerModule = serverContainer.rmiServerModule;
        rmiServerModule.setInitNo(1);
        rmiServerModule.setStartNo(1);
        rmiServerModule.setEndNo(Integer.MAX_VALUE);
        serverContainer.addModule(rmiServerModule);
        ScfSetupUtil.loadModule(serverContainer, application.getBootConfig(), "serverModule");
        serverContainer.initModule();
        ScfServerShutdownTask serverShutdownTask = new ScfServerShutdownTask();
        ApShutdownManager.getInstance().addShutdownTask(serverShutdownTask);
    }

    @Override
    public void start(ApApplication application) throws Exception {
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        serverContainer.start();
        this.getLogger().info("All server modules started.");
    }
}

