/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.server;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.scf.server.ScfServerLogger;

public class ScfServerLoggerManager
extends BcLoggableObject {
    private Map<String, ScfServerLogger> loggerMap = new HashMap<String, ScfServerLogger>();

    public static ScfServerLoggerManager getInstance() throws Exception {
        return SingletonHolder.instance;
    }

    public synchronized ScfServerLogger getLogger(String handleId) throws Exception {
        ScfServerLogger serverLogger = this.loggerMap.get(handleId);
        if (serverLogger == null) {
            serverLogger = new ScfServerLogger(this);
            this.loggerMap.put(handleId, serverLogger);
        }
        return serverLogger;
    }

    public ScfServerLogger removeLogger(String handleId) throws Exception {
        ScfServerLogger serverLogger = this.loggerMap.remove(handleId);
        return serverLogger;
    }

    private static final class SingletonHolder {
        private static final ScfServerLoggerManager instance = new ScfServerLoggerManager();

        private SingletonHolder() {
        }
    }
}

