/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.datasource;

import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.scf.datasource.Y_BackupContext;
import jp.co.extreme.scf.datasource.Y_BackupManager;

class RpcsMeasurementModificationPane
extends FxDecoratePane {
    FxTableView tableView;
    FxButton selectButton;
    FxButton deleteButton;
    FxButton closeButton;
    Stage stage;
    List<List> selectedRowList;
    String columnName = "No.";
    List<Y_BackupContext> backupList;
    Y_BackupManager backupManager;

    public RpcsMeasurementModificationPane(Y_BackupManager backupManager) throws Exception {
        this.backupManager = backupManager;
        this.underLineEnabled();
        this.selectButton = this.createButton(BcWords.getInstance().restoration);
        this.deleteButton = this.createButton(BcWords.getInstance().delete);
        this.closeButton = this.createButton(BcWords.getInstance().close);
        FxFlowPane frowPane1 = new FxFlowPane(11);
        frowPane1.setPrefHeight(40.0);
        this.setTop((Node)frowPane1);
        String description = "\u5fa9\u5143\u306e\u5fc5\u8981\u306a\u7121\u3044\u5834\u5408\u306f\u300c\u9589\u3058\u308b\u300d\u30dc\u30bf\u30f3\u306b\u3066\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5fa9\u5143\u3059\u308b\u5834\u5408\u306f\u5bfe\u8c61\u306e\u5c65\u6b74\u3092\u9078\u629e\u3057\u300c\u5fa9\u5143\u308b\u300d\u30dc\u30bf\u30f3\u3092\u62bc\u4e0b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        this.setDescription(description, 80.0);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setData(List<Y_BackupContext> backupList) throws Exception {
        this.backupList = backupList;
        BcTableColumnModel tableColumnModel = this.createTableColumnModel();
        InnerTableModel tableModel = new InnerTableModel(tableColumnModel, backupList);
        InnerTableView tableView = new InnerTableView();
        FxTableUtil.createColumn(tableColumnModel, tableView, null);
        FxTableRowList fxTableRowList = new FxTableRowList(tableModel);
        tableView.setItems(fxTableRowList);
        this.setCenter((Node)tableView);
        this.selectButton.setDisable(true);
        this.deleteButton.setDisable(true);
    }

    protected void openData(Collection<List> rowCollection) throws Exception {
        for (List row : rowCollection) {
            Integer number = (Integer)row.get(0);
            BcLogUtil.info("number=" + number);
            Y_BackupContext backup = this.backupList.get(number - 1);
            this.backupManager.dataSelect(backup);
        }
    }

    protected void deleteData(Collection<List> rowCollection) throws Exception {
        for (List row : rowCollection) {
            Integer number = (Integer)row.get(0);
            BcLogUtil.info("number=" + number);
            Y_BackupContext backup = this.backupList.get(number - 1);
            this.backupManager.deleteData(backup);
        }
        this.setData(this.backupManager.backupList);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.selectButton) {
            this.openData(this.selectedRowList);
            this.close();
        } else if (ev.getSource() == this.deleteButton) {
            this.deleteData(this.selectedRowList);
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.stage.close();
        this.backupManager.preprocessing_L2();
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    RpcsMeasurementModificationPane.this.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        FxUtil.setWindowSize((Window)this.stage, 740.0, 600.0, true);
        this.stage.setResizable(true);
        this.stage.setTitle("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u5c65\u6b74");
        FxImageHelper.setStageIcon(this.stage);
        this.stage.showAndWait();
    }

    protected BcTableColumnModel createTableColumnModel() {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        MmdField mmdField = new MmdField();
        mmdField.tableColumnName = this.columnName;
        mmdField.dataClass = Integer.class;
        mmdField.horizonalAlignment = 4;
        mmdField.columnCount = 3;
        BcTableColumn tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        mmdField = new MmdField();
        mmdField.tableColumnName = "\u66f4\u65b0\u65e5\u6642";
        mmdField.dataClass = String.class;
        mmdField.horizonalAlignment = 0;
        mmdField.columnCount = 19;
        tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.horizonalAlignment = 0;
        mmdField.columnCount = 19;
        mmdField.displayName = "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u65e5\u6642";
        tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.horizonalAlignment = 2;
        mmdField.columnCount = 32;
        mmdField.displayName = "\u30d5\u30a1\u30a4\u30eb\u540d";
        tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.isEditable = false;
        BcTableUtil.setColumnVisible(tableColumn, false);
        tableColumnModel.addColumn(tableColumn);
        mmdField = new MmdField();
        mmdField.dataClass = Long.class;
        mmdField.horizonalAlignment = 4;
        mmdField.columnCount = 8;
        mmdField.displayName = "\u30b5\u30a4\u30ba";
        tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    class InnerTableModel
    extends BcTableModel {
        List<Y_BackupContext> backupList;

        public InnerTableModel(BcTableColumnModel tableColumnModel, List<Y_BackupContext> backupList) {
            super(tableColumnModel);
            this.backupList = backupList;
        }

        @Override
        public int getColumnCount() {
            return this.tableColumnModel.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return this.backupList.size();
        }

        @Override
        public Object getValueAtModel(int rowId, int columnId) {
            try {
                return this.getValueAt_L2(rowId, columnId);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                return "error";
            }
        }

        protected Object getValueAt_L2(int rowId, int columnId) throws Exception {
            Y_BackupContext backup = this.backupList.get(rowId);
            Object value = null;
            switch (columnId) {
                case 0: {
                    value = rowId + 1;
                    break;
                }
                case 1: {
                    value = BcTimeUtil.toCalendar(backup.lastModified);
                    break;
                }
                case 2: {
                    value = BcTimeUtil.toCalendar(backup.backupTime);
                    break;
                }
                case 3: {
                    value = backup.fileName;
                    break;
                }
                case 4: {
                    value = backup.length;
                }
            }
            return value;
        }
    }

    class InnerTableView<T>
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            RpcsMeasurementModificationPane.this.selectedRowList = null;
            RpcsMeasurementModificationPane.this.selectButton.setDisable(true);
            RpcsMeasurementModificationPane.this.deleteButton.setDisable(true);
            if (nextRowId >= 0) {
                int[] rowIds = new int[]{nextRowId};
                RpcsMeasurementModificationPane.this.selectedRowList = FxTableUtil.createRowList(tableView, rowIds, RpcsMeasurementModificationPane.this.columnName);
                RpcsMeasurementModificationPane.this.selectButton.setDisable(false);
                RpcsMeasurementModificationPane.this.deleteButton.setDisable(false);
            }
        }
    }
}

