/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.app.common.ApApplicationSetup;
import jp.co.extreme.app.common.ApShutdownManager;
import jp.co.extreme.app.common.ApXmlUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.lib.rmi.client.RmiAgentNet;
import jp.co.extreme.rmi.model.RmiNetConfig;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf.client.ScfClientShutdownTask;
import jp.co.extreme.scf.util.ScfSetupUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScfClientSetup
extends BcLoggableObject
implements ApApplicationSetup {
    @Override
    public void setup(ApApplication application) throws Exception {
        ScfClientContainer clientContainer = ScfClientContainer.getInstance();
        ScfSetupUtil.loadModule(clientContainer, application.getBootConfig(), "clientModule");
        clientContainer.initModule();
        ScfClientShutdownTask clientShutdownTask = new ScfClientShutdownTask();
        ApShutdownManager.getInstance().addShutdownTask(clientShutdownTask);
    }

    @Override
    public void start(ApApplication application) throws Exception {
        RmiNetConfig netConfig = this.createNetConfig();
        RmiAgentNet rmixAgentNet = new RmiAgentNet();
        rmixAgentNet.setNetConfig(netConfig);
        ScfClientContainer clientContainer = ScfClientContainer.getInstance();
        clientContainer.setAgent(rmixAgentNet);
        rmixAgentNet.open();
        while (!rmixAgentNet.isOpen()) {
            Thread.sleep(200L);
        }
        this.updaterSetting();
        clientContainer.start();
    }

    protected RmiNetConfig createNetConfig() throws Exception {
        File file = new File(ApApplication.getInstance().toReal("${APP}config/rmix_client.xml"));
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        RmiNetConfig netConfig = this.parseRmiClientConfig(file);
        return netConfig;
    }

    protected RmiNetConfig parseRmiClientConfig(File file) throws Exception {
        Node localHostNode;
        Document rmixClientDom = BcXmlUtil.createDocument(file);
        Node baseNode = BcXmlUtil.getNode(rmixClientDom, "connection");
        if (baseNode == null) {
            throw new FileNotFoundException("Node 'connection' not exists.");
        }
        RmiNetConfig rmiNetConfig = new RmiNetConfig();
        List<Node> domNodeList1 = BcXmlUtil.getNodeList(baseNode, (short)1);
        int i = 0;
        while (i < domNodeList1.size()) {
            Node domNode1 = domNodeList1.get(i);
            if (domNode1.getNodeName().equals("remoteHost")) {
                this.parseRemoteHostConfig(domNode1, rmiNetConfig.remoteHostAddressTable);
            }
            ++i;
        }
        BcTableUtil.sort(rmiNetConfig.remoteHostAddressTable, true, 1);
        if (rmiNetConfig.localHostAddressPort == null) {
            rmiNetConfig.localHostAddressPort = new BcAddressPort();
        }
        if ((localHostNode = BcXmlUtil.getNode(baseNode, "localHost")) != null) {
            ApXmlUtil.parseAddressPort(localHostNode, rmiNetConfig.localHostAddressPort);
        }
        return rmiNetConfig;
    }

    private void parseRemoteHostConfig(Node remoteHostNode, BcTableModel \uff54ableModel) throws Exception {
        BcAddressPort addressPort = ApXmlUtil.parseAddressPort(remoteHostNode);
        String tmpStr = BcXmlUtil.getTextValue(remoteHostNode, "priority");
        ArrayList<Serializable> row = new ArrayList<Serializable>();
        row.add(addressPort);
        int priority = BcNumberUtil.parseInteger(tmpStr);
        if (priority <= 0) {
            priority = Integer.MAX_VALUE;
        }
        row.add(Integer.valueOf(priority));
        \uff54ableModel.addRow(row);
    }

    protected void updaterSetting() throws Exception {
        Document bootConfig = ApApplication.getInstance().getBootConfig();
        Node domNode1 = BcXmlUtil.getNode(bootConfig, "clientUpdator");
        if (domNode1 == null) {
            return;
        }
        String className = BcXmlUtil.getAttribute(domNode1, "class");
        String methodName = BcXmlUtil.getAttribute(domNode1, "method");
        BcReflectUtil.invoke(className, methodName);
    }
}

