/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.poi.PoiExportCondition;

public final class PoiUtil {
    public static List<String> charsetListDefault = new ArrayList<String>();

    static {
        charsetListDefault.add("UTF-8");
        charsetListDefault.add("MS932");
        charsetListDefault.add("SJIS");
        charsetListDefault.add("EUC-JP");
        charsetListDefault.add("windows-31j");
        Charset defaultCharset = Charset.defaultCharset();
        if (!charsetListDefault.contains(defaultCharset.name())) {
            charsetListDefault.add(defaultCharset.name());
        }
    }

    private PoiUtil() {
    }

    public static void setDefault(PoiExportCondition exportCondition) {
        exportCondition.headerEnabled = true;
        exportCondition.fieldSeparator = PoiConstants.FieldSeparator.COMMA.separator;
        exportCondition.lineSeparator = BcStringUtil.lineSeparator;
        exportCondition.lineSeparatorLast = true;
        exportCondition.quotationMarkPolicy = PoiConstants.QuotationMarkPolicy.necessary;
        exportCondition.encoding = "UTF-8";
        exportCondition.bomEnabled = true;
        exportCondition.locale = Locale.getDefault();
        exportCondition.codeMapEnabled = true;
        exportCondition.notVisibleEnabled = false;
    }

    public static PoiExportCondition createExportCondition() throws Exception {
        PoiExportCondition exportCondition = new PoiExportCondition();
        PoiUtil.setDefault(exportCondition);
        return exportCondition;
    }
}

