/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.fx;

import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.app.common.ApApplicationContext;
import jp.co.extreme.base.util.BcISO;
import jp.co.extreme.base.util.BcLocaleUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.fx.FxxAbstractDesktopPane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.fx.XsysMenuPane;
import jp.co.extreme.scf4.fx.HfxClientUtil;
import jp.co.extreme.scf6.fx.JfxAboutPane;
import org.w3c.dom.Document;

public class XsysDesktop
extends FxxAbstractDesktopPane {
    private static XsysDesktop instance = new XsysDesktop();
    XsysMenuPane menuPane1;
    int ww = 478;
    int wh = 720;
    public static int wx = 60;
    int wy = 20;
    protected MenuItem englishMenuItem = new MenuItem(BcISO.ISO_639.English.name());
    protected MenuItem japaneseMenuItem = new MenuItem(BcISO.ISO_639.Japanese.name());

    public static XsysDesktop getInstance() throws Exception {
        return instance;
    }

    private XsysDesktop() {
    }

    @Override
    protected void init() throws Exception {
        this.menuPane1 = new XsysMenuPane();
        this.setContentNode((Node)this.menuPane1);
        ApApplication application = ApApplication.getInstance();
        if (XsysConstants.Function.MovieFiler.appName.equals(application.getApplicationContext().appName)) {
            this.ww = 290;
            this.wh = 340;
        }
        super.init();
    }

    @Override
    protected Menu createWindowMenu() throws Exception {
        Menu menu = super.createWindowMenu();
        Menu languageMenu = new Menu(BcWords.getInstance().language);
        menu.getItems().add((Object)languageMenu);
        this.englishMenuItem.setOnAction(this.actionEventHandler);
        this.englishMenuItem.setGraphic((Node)FxImageHelper.createImageView_icon("flag_united_kingdom_64x64.png"));
        this.englishMenuItem.setDisable(BcLocaleUtil.getIso639() == BcISO.ISO_639.English);
        languageMenu.getItems().add((Object)this.englishMenuItem);
        this.japaneseMenuItem.setOnAction(this.actionEventHandler);
        this.japaneseMenuItem.setGraphic((Node)FxImageHelper.createImageView_icon("flag_japan_64x64.png"));
        this.japaneseMenuItem.setDisable(BcLocaleUtil.getIso639() == BcISO.ISO_639.Japanese);
        languageMenu.getItems().add((Object)this.japaneseMenuItem);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.englishMenuItem) {
            this.setLangage(BcISO.ISO_639.English.code);
        } else if (ev.getSource() == this.japaneseMenuItem) {
            this.setLangage(BcISO.ISO_639.Japanese.code);
        }
    }

    public void setLangage(String langageCode) throws Exception {
        Document generalConfig = ApApplication.getInstance().getGeneralConfig();
        BcXmlUtil.setTextValue(generalConfig.getDocumentElement(), "langageCode", langageCode);
        ApApplication.getInstance().updateGeneralConfig(generalConfig);
        String msg = String.valueOf(BcWords.getInstance().Changed_language) + "\n" + BcWords.getInstance().It_takes_effect_after_restarting_the_system;
        FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().information, 1);
    }

    @Override
    public void aboutAction() throws Exception {
        JfxAboutPane aboutPane = new JfxAboutPane();
        aboutPane.show((Window)this.stage);
    }

    @Override
    protected void createUserMenu(MenuBar menuBar) throws Exception {
        this.menuPane1.setMenu(menuBar);
    }

    @Override
    public void exitAction() throws Exception {
        if (HfxClientUtil.confirmExit((Window)this.stage)) {
            this.stage.close();
        }
    }

    public void show() throws Exception {
        if (this.stage != null) {
            this.stage.show();
            this.stage.toFront();
            return;
        }
        this.init();
        this.createStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                if (!HfxClientUtil.confirmExit((Window)XsysDesktop.this.stage)) {
                    ev.consume();
                }
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ApApplication.getInstance().exit();
            }
        });
        this.stage.iconifiedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> prop, Boolean oldValue, Boolean newValue) {
            }
        });
        ReadOnlyBooleanProperty fullScreenProperty = this.stage.fullScreenProperty();
        fullScreenProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isFullScreen) {
                isFullScreen.booleanValue();
            }
        });
        this.stage.setResizable(false);
        ApApplicationContext applicationContext = ApApplication.getInstance().getApplicationContext();
        this.stage.setTitle(String.valueOf(applicationContext.appName) + " Ver." + applicationContext.version);
        FxImageHelper.setStageIcon(this.stage);
        FxUtil.setWindowLocation((Window)this.stage, wx, this.wy, this.ww, this.wh);
        this.stage.show();
    }

    public static void show2() throws Exception {
        XsysDesktop.getInstance().show();
    }
}

