/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.client;

import java.io.File;
import java.nio.charset.Charset;
import javafx.application.Platform;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.app.common.ApConstants;
import jp.co.extreme.app.common.ApLogUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcEncoder;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.module.advm.client.AdvmAdvertisementManager;
import jp.co.extreme.module.advm.client.AdvmAdvertisementTask;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xsys.fx.XdtsLicensePane;
import jp.co.extreme.module.xsys.fx.XsysDesktop;
import jp.co.extreme.module.xupd.client.XupdChacker;
import jp.co.extreme.scf.client.ScfAbstractClientModule;
import jp.co.extreme.scf5.swg.IswgTablePanel;
import jp.co.extreme.swing.SwgUtil;

public class XsysClientModule
extends ScfAbstractClientModule {
    public BcMonitor monitor = new BcMonitor();
    boolean licenseAgreement;

    @Override
    public void init() throws Exception {
        String javaVersion = BcRuntimeUtil.getJavaVersion();
        boolean doExit = false;
        final BcMonitor monitor = new BcMonitor();
        if (!BcRuntimeUtil.isJava_1_8()) {
            doExit = true;
            monitor.lock();
            final String msg = String.format("\u672c\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f Java %s \u3067\u306f\u7a3c\u52d5\u3057\u307e\u305b\u3093\u3002", javaVersion);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FxOptionPane.showMessageDialog(msg, BcWords.getInstance().error, 0);
                        monitor.unLock();
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        }
        while (monitor.isLock()) {
            Thread.sleep(1000L);
        }
        if (doExit) {
            System.exit(ApConstants.ExitCode.NG.code);
        }
    }

    @Override
    public void start() throws Exception {
        boolean isAgreement = this.licenseAgreement();
        if (!isAgreement) {
            ApApplication.getInstance().exit(ApConstants.ExitCode.OK.code);
            return;
        }
        IswgTablePanel.printButtonEnabled = false;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BcReflectUtil.invoke(XsysDesktop.class.getName(), "show2");
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected boolean licenseAgreement() throws Exception {
        String vPath = "${APP}data/license_agreement.log";
        String rPath = ApApplication.getInstance().toReal(vPath);
        File agreementLogFile = new File(rPath);
        BcLogUtil.debug("agreementLogFile=" + agreementLogFile.getPath());
        if (agreementLogFile.exists()) {
            return true;
        }
        this.monitor.lock();
        vPath = "${APP}\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u4f7f\u7528\u8a31\u8afe\u5951\u7d04\u66f8.txt";
        rPath = ApApplication.getInstance().toReal(vPath);
        File licenseFile = new File(rPath);
        String charsetName = BcEncoder.detectEncoding(licenseFile);
        Charset charset = Charset.forName(charsetName);
        final StringBuilder licenseStrBuf = BcFileUtil.readAsStringBuilder(new File(rPath), charset);
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> System.out.println("Inside Platform.runLater()"));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    XdtsLicensePane licensePane = new XdtsLicensePane();
                    licensePane.textArea.setText(licenseStrBuf.toString());
                    XsysClientModule.this.licenseAgreement = licensePane.show(null);
                    XsysClientModule.this.monitor.unLock();
                }
                catch (Exception ex) {
                    XsysClientModule.this.handleException(ex);
                }
            }
        });
        this.monitor.sync();
        if (this.licenseAgreement) {
            StringBuilder agreementLog = new StringBuilder();
            agreementLog.append(BcTimeUtil.toString(BcTimeUtil.createCalendar(), "yyyy/MM/dd HH:mm:ss.SSS"));
            agreementLog.append(ApLogUtil.lineSeparator);
            agreementLog.append(ApLogUtil.jvmInfoLog());
            BcFileUtil.makeParent(agreementLogFile);
            BcFileUtil.save(agreementLogFile, agreementLog.toString(), charset);
            return true;
        }
        return false;
    }

    protected int chackUpdate() throws Exception {
        XupdChacker xupdChacker = new XupdChacker();
        int exitCode = xupdChacker.check(this.monitor);
        this.monitor.sync();
        return exitCode;
    }

    protected void advertisement() throws Exception {
        AdvmAdvertisementManager advertisementManager = new AdvmAdvertisementManager();
        advertisementManager.setAdvertisementTask(new AdvmAdvertisementTask());
        try {
            advertisementManager.checkBootConfig(this.monitor);
            this.monitor.sync();
            XdtsConstants.LIMIT_tableCount = -1;
            XdtsConstants.LIMIT_recordCount = -1;
        }
        catch (Exception ex) {
            this.monitor.unLock();
            BcLogUtil.error(ex);
        }
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

