/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javafx.scene.Node;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.effect.Reflection;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxEffectUtil;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;

public class Z_XsodJBackgroundPane
extends FxBorderPane {
    public Z_XsodJBackgroundPane() throws Exception {
        Pane group = new Pane();
        Node sunNode = this.createSunNode();
        group.getChildren().add((Object)sunNode);
        Node fujiNode = this.createFujiNode();
        fujiNode.setLayoutX(320.0);
        fujiNode.setLayoutY(500.0);
        group.getChildren().add((Object)fujiNode);
        Node titleNode = this.createTitleNode();
        group.getChildren().add((Object)titleNode);
        StackPane baseParent = XsodUiFactory.getInstance().createBackgrondNode((Node)group, Color.BLACK, 1.0);
        this.setCenter((Node)baseParent);
    }

    protected Node createBackground() throws Exception {
        String filePath = ApApplication.getInstance().toReal("${APP}data/MIYA160131480493_TP_V.jpg");
        File file = new File(filePath);
        BcLogUtil.debug("file=" + file.getPath());
        if (!file.exists()) {
            BcLogUtil.debug("Not found. file=" + file.getPath());
        }
        FileInputStream is = new FileInputStream(file);
        Image image = new Image((InputStream)is);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        return imageView;
    }

    protected Node createSunNode() throws Exception {
        Circle circle = new Circle();
        circle.setCenterX(1500.0);
        circle.setCenterY(140.0);
        circle.setRadius(450.0);
        Stop[] stops = new Stop[]{new Stop(0.0, Color.RED), new Stop(1.0, Color.BLACK)};
        LinearGradient linearGradient1 = new LinearGradient(0.0, 0.0, 0.0, 0.9, true, CycleMethod.NO_CYCLE, stops);
        circle.setFill((Paint)linearGradient1);
        circle.setCache(true);
        GaussianBlur gaussianBlur = new GaussianBlur();
        gaussianBlur.setRadius(40.0);
        circle.setEffect((Effect)gaussianBlur);
        return circle;
    }

    protected Node createFujiNode() throws Exception {
        String filePath = ApApplication.getInstance().toReal("${APP}data/fujiyama_2.png");
        File file = new File(filePath);
        BcLogUtil.debug("file=" + file.getPath());
        if (!file.exists()) {
            BcLogUtil.debug("Not found. file=" + file.getPath());
        }
        FileInputStream is = new FileInputStream(file);
        Image image = new Image((InputStream)is);
        ImageView imageView = new ImageView(image);
        GaussianBlur gaussianBlur2 = new GaussianBlur();
        gaussianBlur2.setRadius(30.0);
        Reflection reflection = new Reflection();
        Blend blend = new Blend();
        blend.setTopInput((Effect)gaussianBlur2);
        blend.setMode(BlendMode.ADD);
        blend.setBottomInput((Effect)reflection);
        imageView.setEffect((Effect)blend);
        return imageView;
    }

    protected Node createTitleNode() throws Exception {
        String filePath = ApApplication.getInstance().toReal("${APP}data/\u98db\u9f8dTTF\u6559\u80b2\u6f22\u5b57.ttf");
        Font font = Font.loadFont((String)("file:" + filePath), (double)300.0);
        Text shopName = new Text();
        shopName.setFont(font);
        shopName.setTextAlignment(TextAlignment.LEFT);
        shopName.setFill((Paint)Color.GOLD);
        shopName.setStroke((Paint)Color.GOLD);
        shopName.setText("\u56de\u5929");
        shopName.setEffect((Effect)FxEffectUtil.createDropShadow());
        TextFlow textFlow = new TextFlow();
        textFlow.setLayoutX(200.0);
        textFlow.setLayoutY(700.0);
        textFlow.getChildren().add((Object)shopName);
        GaussianBlur gaussianBlur = new GaussianBlur();
        gaussianBlur.setRadius(10.0);
        textFlow.setEffect((Effect)gaussianBlur);
        return textFlow;
    }
}

