/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xmmd.server;

import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xmmd.common.XmmdUtil;
import jp.co.extreme.module.xmmd.dao.XmmdFieldDAO;
import jp.co.extreme.module.xmmd.dao.XmmdIndexDAO;
import jp.co.extreme.module.xmmd.dao.XmmdIndexFieldDAO;
import jp.co.extreme.module.xmmd.dao.XmmdModelDAO;
import jp.co.extreme.module.xmmd.model.XmmdField;
import jp.co.extreme.module.xmmd.model.XmmdIndex;
import jp.co.extreme.module.xmmd.model.XmmdModel;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.context.SqlContext;

public class XmmdServerUtil {
    private XmmdServerUtil() {
    }

    public static XmmdServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public XmmdModel createXmmdModel(SqlConnection sqlConn, String tableName, boolean getPrimaryKey, SqlContext sqlContext) throws Exception {
        MmdModel mmdModel = sqlContext.createModelMetaData(sqlConn, tableName);
        XmmdModel xmmd = XmmdUtil.toXmmdModel(mmdModel);
        return xmmd;
    }

    public void putModel(BcLogger logger, DtsSession dtsSession, XmmdModel xmmd) throws Exception {
        XmmdModelDAO.getInstance().putEntity(dtsSession, xmmd);
        int i = 0;
        while (i < xmmd.fieldList.size()) {
            XmmdField xmmdField = xmmd.fieldList.get(i);
            xmmdField.schemaId = xmmd.schemaId;
            xmmdField.tableName = xmmd.logicalName;
            ++i;
        }
        XmmdFieldDAO.getInstance().putEntityCollection(dtsSession, xmmd.fieldList);
        for (XmmdIndex xmmdIndex : xmmd.indexNameMap.values()) {
            xmmdIndex.schemaId = xmmd.schemaId;
        }
        XmmdIndexDAO.getInstance().putEntityCollection(dtsSession, xmmd.indexNameMap.values());
        for (XmmdIndex xmmdIndex : xmmd.indexNameMap.values()) {
        }
    }

    public XmmdModel getModel(DtsSession dtsSession, int schemaId, String modelName) throws Exception {
        XmmdModel xmmd = XmmdModelDAO.getInstance().getByName(dtsSession, schemaId, modelName);
        List<XmmdField> filedList = XmmdFieldDAO.getInstance().getList(dtsSession, xmmd.schemaId, xmmd.logicalName);
        int i = 0;
        while (i < filedList.size()) {
            XmmdField xmmdField = filedList.get(i);
            xmmd.addField(xmmdField);
            ++i;
        }
        List<XmmdIndex> indexList = XmmdIndexDAO.getInstance().getList(dtsSession, xmmd.schemaId, xmmd.logicalName);
        int i2 = 0;
        while (i2 < indexList.size()) {
            XmmdIndex xmmdIndex = indexList.get(i2);
            xmmd.addIndex(xmmdIndex);
            ++i2;
        }
        return xmmd;
    }

    public void deleteModel(BcLogger logger, DtsSession dtsSession, int schemaId, String modelName) throws Exception {
        List<XmmdIndex> indexList = XmmdIndexDAO.getInstance().getList(dtsSession, schemaId, modelName);
        int i = 0;
        while (i < indexList.size()) {
            XmmdIndex xmmdIndex = indexList.get(i);
            XmmdIndexFieldDAO.getInstance().deleteByIndexName(dtsSession, xmmdIndex.schemaId, xmmdIndex.indexName);
            ++i;
        }
        long cnt = XmmdIndexDAO.getInstance().deleteByModelName(dtsSession, schemaId, modelName);
        BcLogUtil.debug("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u524a\u9664\u6570=" + cnt);
        cnt = XmmdFieldDAO.getInstance().deleteByModelName(dtsSession, schemaId, modelName);
        BcLogUtil.debug("\u30d5\u30a3\u30fc\u30eb\u30c9\u524a\u9664\u6570=" + cnt);
        cnt = XmmdModelDAO.getInstance().deleteByModelName(dtsSession, modelName);
        BcLogUtil.debug("\u30e2\u30c7\u30eb\u524a\u9664\u6570=" + cnt);
    }

    /* synthetic */ XmmdServerUtil(XmmdServerUtil xmmdServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final XmmdServerUtil instance = new XmmdServerUtil(null);

        private SingletonHolder() {
        }
    }
}

