/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xjps.fx;

import java.io.File;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xjps.fx.XjpsJavaParser;
import jp.co.extreme.module.xjps.fx.XjpsJavaParserResultPane;
import jp.co.extreme.scf4.fx.HfxLoadableTablePane;

public class XjpsJavaParserPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField directoryPathField = new FxTextField();
    FxButton directoryChooseButton = FxUtil.createBrowsButton(null);
    DirectoryChooser directoryChooser = new DirectoryChooser();
    FxTextArea statusTextArea = new FxTextArea();
    Button executeButton;
    Button cancelButton;
    BcMonitor monitor = new BcMonitor();
    InnerJavaParser javaParser = new InnerJavaParser();
    static final String title = "Java\u30bd\u30fc\u30b9\u89e3\u6790";
    Stage stage;

    public XjpsJavaParserPane() throws Exception {
        this.initComponent();
        this.directoryPathField.setText(System.getProperty("user.home"));
    }

    protected void initComponent() throws Exception {
        this.setCenter((Node)this.centerPane);
        this.executeButton = this.createButton(BcWords.getInstance().execute);
        this.cancelButton = this.createButton(BcWords.getInstance().close);
        this.directoryPathField.setPrefColumnCount(80);
        this.directoryChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("\u30bd\u30fc\u30b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea"), new Node[]{this.directoryPathField, this.directoryChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(""), new Node[0]);
        this.centerPane.addNodeUnit(nodeUnit);
        this.statusTextArea.setPrefColumnCount(82);
        this.statusTextArea.setPrefRowCount(6);
        this.statusTextArea.setEditable(false);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().situation), new Node[]{this.statusTextArea});
        this.centerPane.addNodeUnit(nodeUnit);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.directoryChooseButton) {
            FxUtil.initDirectoryChooser(this.directoryChooser, this.directoryPathField.getText());
            File file = this.directoryChooser.showDialog((Window)this.stage);
            if (file != null) {
                this.directoryPathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.executeButton) {
            BcResult result = new BcResult();
            BcInputValidator inputValidator = BcInputValidator.getInstance();
            inputValidator.isFileExists(this.directoryPathField.getText(), BcWords.getInstance().file, result.getErrorList());
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(BcWords.getInstance().warning, result.getErrorList()).toString();
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            InnerTask task = new InnerTask();
            new Thread((Runnable)((Object)task)).start();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    protected void showResult(final BcTableColumnModel tableColumnModel, final BcTableModel tableModel) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XjpsJavaParserPane.this.showResult2(tableColumnModel, tableModel);
                }
                catch (Exception ex) {
                    XjpsJavaParserPane.this.handleException(ex);
                }
            }
        });
    }

    protected void showResult2(BcTableColumnModel tableColumnModel, BcTableModel tableModel) throws Exception {
        FxTableView tableView = new FxTableView();
        FxTableUtil.createColumn(tableColumnModel, tableView, null);
        FxTableRowList tableRowList = new FxTableRowList(tableModel);
        tableView.setItems(tableRowList);
        HfxLoadableTablePane optionTablePane = new HfxLoadableTablePane();
        optionTablePane.setTableView(tableView);
        optionTablePane.setMainContent((Node)tableView);
        XjpsJavaParserResultPane javaParserResultPane = new XjpsJavaParserResultPane();
        javaParserResultPane.setCenter((Node)optionTablePane);
        javaParserResultPane.show(null);
        javaParserResultPane.stage.toFront();
    }

    public void close() throws Exception {
        this.stage.close();
    }

    public void show() throws Exception {
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XjpsJavaParserPane.this.directoryPathField.requestFocus();
                }
                catch (Exception ex) {
                    XjpsJavaParserPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XjpsJavaParserPane.this.close();
                }
                catch (Exception ex) {
                    XjpsJavaParserPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(260.0);
        this.stage.setResizable(false);
        this.stage.setTitle(title);
        this.stage.show();
    }

    class InnerJavaParser
    extends XjpsJavaParser {
        @Override
        public void setStatus(final String status) throws Exception {
            BcLogUtil.info(status);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    ((InnerJavaParser)InnerJavaParser.this).XjpsJavaParserPane.this.statusTextArea.setText(status);
                }
            });
        }
    }

    class InnerTask
    extends Task {
        public Void call() {
            try {
                File sourceFile = new File(XjpsJavaParserPane.this.directoryPathField.getText());
                XjpsJavaParserPane.this.javaParser.init();
                XjpsJavaParserPane.this.javaParser.parse(sourceFile);
                XjpsJavaParserPane.this.showResult(XjpsJavaParserPane.this.javaParser.tableColumnModel, XjpsJavaParserPane.this.javaParser.tableModel);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            XjpsJavaParserPane.this.monitor.unLock();
            return null;
        }
    }
}

