/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.swg;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.event.ListSelectionEvent;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilConditionSet;
import jp.co.extreme.module.xfil.fx.XfilFxHelper;
import jp.co.extreme.module.xfil.model.XfilAnalysisCondition;
import jp.co.extreme.module.xfil.rmo.XfilIndexGroupRMO;
import jp.co.extreme.module.xfil.stub.XfilIndexGroupStub;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf3.client.ScfTableLoadTask;
import jp.co.extreme.scf5.swg.IswgAbstractDataViewPanel;
import jp.co.extreme.scf5.swg.IswgLoadableTablePanel;
import jp.co.extreme.scf6.swg.JswgAbstractDataViewPanel_FxCondition;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgOptionPane;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgTableViewUtil;
import jp.co.extreme.swing.SwgUtil;

public class XfilIndexGroupListPanel
extends JswgAbstractDataViewPanel_FxCondition {
    public XfilIndexGroupListPanel() throws Exception {
        super(IswgAbstractDataViewPanel.DataViewStyle.Default);
        Parent conditionNode = this.createConditionNode(-1, null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().indexGroupList.toPlain();
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionPane.addNodeUnit(conditionSet.keywordUnit);
        conditionPane.addNodeUnit(conditionSet.registrationPeriodUnit);
        if (preConditionNode != null) {
            InnerConditionPane preConditionPane = (InnerConditionPane)preConditionNode;
            conditionSet.setConditionSet(preConditionPane.conditionSet);
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        XfilAnalysisCondition analysisCondition = conditionPane.conditionSet.getCondition();
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilIndexGroupRMO.class.getName());
        rmiReq.setMethodName(XfilIndexGroupRMO.Method.list.getMethodName());
        rmiReq.addData(analysisCondition);
        return rmiReq;
    }

    @Override
    public IswgLoadableTablePanel createTablePanel() throws Exception {
        InnerTablePanel tablePanel = new InnerTablePanel();
        return tablePanel;
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("table_view_64x64.png");
    }

    class InnerConditionPane
    extends FxFlowPane {
        XfilConditionSet conditionSet;

        public InnerConditionPane() throws Exception {
            super(11);
            this.conditionSet = new XfilConditionSet();
            this.conditionSet.fileCheckBox.setSelected(true);
        }
    }

    class InnerTablePanel
    extends IswgLoadableTablePanel {
        List<List> rowList;
        Number entityId;
        SwgButton addButton;
        SwgButton openButton;
        SwgButton deleteButton;

        public InnerTablePanel() throws Exception {
            this.setVisualSaveEnavled(true);
            this.addButton = SwgUtil.createAddButton();
            this.addButton.addActionListener(this.actionListener);
            this.tableControlPanel.addControl3(this.addButton);
            this.openButton = SwgUtil.createOpenButton();
            this.openButton.addActionListener(this.actionListener);
            this.openButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openButton);
            this.deleteButton = SwgUtil.createDeleteButton();
            this.deleteButton.addActionListener(this.actionListener);
            this.deleteButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.deleteButton);
        }

        @Override
        public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
            super.tableColumnReceived(tableLoadTask, tableColumnList, rowSize, tableContext);
            this.addButton.setEnabled(true);
        }

        @Override
        protected SwgTableView createTableView() throws Exception {
            SwgTableView tableView = super.createTableView();
            return tableView;
        }

        @Override
        protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
            super.tableSelectionChanged(ev);
            if (!ev.getValueIsAdjusting()) {
                SwgTableView tableView = this.getTableView();
                if (tableView.getSelectedRows().length > 0) {
                    this.rowList = SwgTableViewUtil.getRowList(tableView, tableView.getSelectedRows(), XfilConstants.xfil_index_group.id.fullName());
                    this.entityId = (Number)this.rowList.get(0).get(0);
                    this.openButton.setEnabled(true);
                    this.deleteButton.setEnabled(true);
                } else {
                    this.openButton.setEnabled(false);
                    this.deleteButton.setEnabled(false);
                }
            }
        }

        @Override
        protected void tableMouseClicked(MouseEvent ev) throws Exception {
            super.tableMouseClicked(ev);
            if (ev.getClickCount() != 2) {
                return;
            }
            XfilFxHelper.getInstance().openIndexGroupPane(this.entityId.longValue());
        }

        @Override
        protected void actionPerformed2(ActionEvent ev) throws Exception {
            BcResult result;
            String msg;
            super.actionPerformed2(ev);
            if (ev.getSource() == this.addButton) {
                XfilFxHelper.getInstance().openIndexGroupPane(-1L);
            } else if (ev.getSource() == this.openButton) {
                XfilFxHelper.getInstance().openIndexGroupPane(this.entityId.longValue());
            } else if (ev.getSource() == this.deleteButton && SwgOptionPane.showConfirmDialog(this, msg = String.format(BcWords.getInstance().Do_you_want_to_delete, new Object[0]), BcWords.getInstance().confirmation, 0) == 0 && (result = XfilIndexGroupStub.getInstance().delete(this.entityId.longValue())).hasError()) {
                Component messageComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                SwgOptionPane.showMessageDialog(this, messageComponent, BcWords.getInstance().warning, 2);
            }
        }
    }
}

