/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxTitledPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilCaptureIndicationPane;
import jp.co.extreme.module.xfil.fx.XfilCrawlConditionPane1;
import jp.co.extreme.module.xfil.model.XfilAnalysisCondition;
import jp.co.extreme.module.xfil.model.XfilCrawler;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureCondition;
import jp.co.extreme.module.xfil.rmo.XfilCrawlRMO;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf4.fx.HfxTaskMonitor;

public class Z_XfilCrawlIndicationPane
extends FxDecoratePane {
    Mode mode;
    XfilCrawlConditionPane1 crawlConditionPane1;
    XfilCaptureIndicationPane captureIndicationPane;
    Button executeButton;
    Button cancelButton;
    double wWidth = 980.0;
    double wHeight;
    String title;
    Image windowImage;
    Stage stage;

    public Z_XfilCrawlIndicationPane(Mode mode) throws Exception {
        this.mode = mode;
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.executeButton = FxUtil.createExecuteButton();
        this.executeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.executeButton);
        this.cancelButton = FxUtil.createCancelButton();
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        VBox vBox = new VBox();
        vBox.setSpacing(12.0);
        if (this.mode == Mode.fileCrawl) {
            this.crawlConditionPane1 = new XfilCrawlConditionPane1();
            FxTitledPane titledPane1 = new FxTitledPane();
            titledPane1.setTitle(String.valueOf(XfilWords.getInstance().crawler) + " " + BcWords.getInstance().condition);
            titledPane1.setContentNode((Node)this.crawlConditionPane1);
            vBox.getChildren().addAll((Object[])new Node[]{titledPane1});
            this.title = XfilWords.getInstance().crawler;
            this.windowImage = FxImageHelper.getImage("folder_view_64x64.png");
        } else if (this.mode == Mode.videoCapture) {
            this.title = XfilWords.getInstance().videoCaptureCondition.toPlain();
            this.windowImage = FxImageHelper.getImage("screenshot_64x64.png");
        }
        this.captureIndicationPane = new XfilCaptureIndicationPane(this);
        FxTitledPane titledPane2 = new FxTitledPane();
        titledPane2.setContentNode((Node)this.captureIndicationPane);
        if (this.mode != Mode.videoCapture) {
            titledPane2.setTitle(XfilWords.getInstance().videoCaptureCondition.toPlain());
        }
        vBox.getChildren().addAll((Object[])new Node[]{titledPane2});
        this.wHeight = this.crawlConditionPane1.getPrefHeight() + this.captureIndicationPane.getPrefHeight() + 120.0;
        this.setCenter((Node)vBox);
        this.setPadding(new Insets(8.0));
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            BcResult result = this.execute();
            if (result.hasError()) {
                String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().error, 0);
                return;
            }
            HfxTaskMonitor.getInstance().show();
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public BcResult execute() throws Exception {
        XfilCrawler crawler = null;
        XfilAnalysisCondition analysisConditionA = null;
        XfilAnalysisCondition analysisConditionB = this.captureIndicationPane.getCondition();
        XfilVideoCaptureCondition captureCondition = this.captureIndicationPane.videoCaptureConditionPane.captureConditionSet.getCondition();
        if (this.crawlConditionPane1 != null) {
            crawler = this.crawlConditionPane1.getCondition();
        } else {
            analysisConditionA = new XfilAnalysisCondition();
        }
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilCrawlRMO.class.getName());
        rmiReq.setMethodName(XfilCrawlRMO.Method.fileCrawl1.getMethodName());
        rmiReq.addData(crawler);
        rmiReq.addData(analysisConditionB);
        rmiReq.addData(captureCondition);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        BcResult result = (BcResult)rmiRes.getData();
        return result;
    }

    public void close() {
        this.stage.close();
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(this.wWidth);
        this.stage.setHeight(this.wHeight);
        this.stage.setResizable(false);
        this.stage.setTitle(this.title);
        this.stage.getIcons().add((Object)this.windowImage);
        this.stage.show();
    }

    public static enum Mode {
        fileCrawl,
        videoCapture;

    }
}

