/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.swg;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcISO;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.swing.SwgBorderPanel;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgControlPanel;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgTableViewUtil;

class XdtsLogicalNameTablePanel
extends SwgBorderPanel {
    SwgControlPanel controlPanel = new SwgControlPanel();
    SwgButton addRowButton;
    SwgButton deleteRowButton;
    SwgButton selectAllButton;
    BcTableColumnModel tableColumnModel;
    BcTableModel tableModel;
    SwgTableView tableView;
    JScrollPane tableScrollPane;

    public XdtsLogicalNameTablePanel() throws Exception {
        this.addRowButton = new SwgButton(BcWords.getInstance().addRow, new ImageIcon(AwtImageHelper.getImageAsIcon("add_64x64.png")));
        this.deleteRowButton = new SwgButton(BcWords.getInstance().deleteRow, new ImageIcon(AwtImageHelper.getImageAsIcon("cancel_64x64.png")));
        this.selectAllButton = new SwgButton(BcWords.getInstance().selectAll.toPlain(), new ImageIcon(AwtImageHelper.getImageAsIcon("table_selection_all_64x64.png")));
        this.tableScrollPane = new JScrollPane();
        this.add((Component)this.controlPanel, "South");
        this.add((Component)this.tableScrollPane, "Center");
        this.addRowButton.addActionListener(this.actionListener);
        this.controlPanel.add((Component)this.addRowButton, -1);
        this.deleteRowButton.addActionListener(this.actionListener);
        this.controlPanel.add((Component)this.deleteRowButton, -1);
        this.selectAllButton.addActionListener(this.actionListener);
        this.controlPanel.add((Component)this.selectAllButton, -1);
    }

    public void setData(List<EtcWord> wordList) throws Exception {
        this.tableColumnModel = XdtsUtil.createWordTableColumnModel();
        this.tableModel = new InnerTableModel(this.tableColumnModel, wordList);
        this.tableView = new InnerTableView(this.tableModel, this.tableColumnModel);
        this.tableView.setSelectionMode(2);
        this.tableView.setRowHeight(SwgTableViewUtil.ROW_HEIGHT + 2);
        this.tableScrollPane.getViewport().removeAll();
        this.tableScrollPane.getViewport().add(this.tableView);
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.addRowButton) {
            this.tableModel.addRow(null);
            this.tableView.scrollRectToVisible(this.tableView.getCellRect(this.tableView.getRowCount(), 0, true));
        } else if (ev.getSource() == this.deleteRowButton) {
            int[] selectedRows = this.tableView.getSelectedRows();
            List[] rows = this.tableModel.removeRows(selectedRows);
            BcLogUtil.debug("deleted rows.lengt=" + rows.length);
        } else if (ev.getSource() == this.selectAllButton) {
            this.tableView.selectAll();
        }
    }

    class InnerTableModel
    extends BcTableModel {
        private static final long serialVersionUID = 5243014823197725200L;
        List<EtcWord> wordList;

        public InnerTableModel(BcTableColumnModel tableColumnModel, List<EtcWord> wordList) throws Exception {
            super(tableColumnModel);
            this.wordList = wordList;
        }

        @Override
        public int getRowCount() {
            return this.wordList.size();
        }

        @Override
        public Object getValueAtModel(int rowModelId, int columnModelId) {
            EtcWord word = this.wordList.get(rowModelId);
            String value = null;
            switch (columnModelId) {
                case 0: {
                    value = word.code;
                    break;
                }
                case 1: {
                    value = word.lang;
                    break;
                }
                case 2: {
                    value = word.value;
                    break;
                }
                case 3: {
                    value = word.note;
                }
            }
            return value;
        }

        @Override
        public Object setValueAtModel(Object newValue, int rowModelId, int columnModelId) {
            EtcWord word = this.wordList.get(rowModelId);
            String oldValue = null;
            switch (columnModelId) {
                case 0: {
                    oldValue = word.code;
                    word.code = (String)newValue;
                    break;
                }
                case 1: {
                    oldValue = word.lang;
                    word.lang = (String)newValue;
                    break;
                }
                case 2: {
                    oldValue = word.value;
                    word.value = (String)newValue;
                    break;
                }
                case 3: {
                    oldValue = word.note;
                    word.note = (String)newValue;
                }
            }
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addRow(List row) {
            BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
            synchronized (bcTableColumnModel) {
                EtcWord word = new EtcWord();
                word.lang = BcISO.ISO_639.Japanese.code;
                this.wordList.add(word);
                int rowId = this.getRowCount() - 1;
                if (this.indexer != null) {
                    this.indexer.addIndex(1);
                }
                this.fireTableRowsInserted(rowId, rowId);
                return rowId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List removeRow(int rowId) {
            BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
            synchronized (bcTableColumnModel) {
                int rowModelId = this.toRowId(rowId);
                this.wordList.remove(rowModelId);
                if (this.indexer != null) {
                    this.indexer.removeIndex(rowId, rowId);
                }
            }
            this.fireTableRowsDeleted(rowId, rowId);
            return null;
        }
    }

    class InnerTableView
    extends SwgTableView {
        public InnerTableView(TableModel tableModel, TableColumnModel tableColumnModel) throws Exception {
            super(tableModel, tableColumnModel);
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            if (ev.getValueIsAdjusting()) {
                return;
            }
            XdtsLogicalNameTablePanel.this.deleteRowButton.setEnabled(false);
            int[] selectedRowIds = XdtsLogicalNameTablePanel.this.tableView.getSelectedRows();
            if (selectedRowIds.length > 0) {
                XdtsLogicalNameTablePanel.this.deleteRowButton.setEnabled(true);
            }
        }
    }
}

