/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.event.BcProgressEvent;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsMenuIF;
import jp.co.extreme.module.xdts.fx.XdtsTimerTablePane;
import jp.co.extreme.module.xdts.fx.XdtsTimerTaskPane;
import jp.co.extreme.module.xdts.model.XdtsTimer;

public class XdtsTaskMenuPane
extends FxBorderPane
implements BcEventHandler<BcProgressEvent>,
XdtsMenuIF {
    FxBorderPane borderPane1 = new FxBorderPane();
    FxBorderPane borderPane2 = new FxBorderPane();
    XdtsTimerTablePane timerTablePane;
    XdtsTimer timer;
    HBox hBox1 = new HBox(8.0);
    Button addTimerButton;
    Button editTimerButton;
    Button deleteTimerButton;

    public XdtsTaskMenuPane() throws Exception {
        this.addTimerButton = new Button(XdtsWords.getInstance().addTimer);
        this.editTimerButton = new Button(XdtsWords.getInstance().editTimer);
        this.deleteTimerButton = new Button(XdtsWords.getInstance().deleteTimer);
        this.timerTablePane = new XdtsTimerTablePane(this);
        this.setComponant();
        this.setTimer(null);
    }

    protected void setComponant() throws Exception {
        this.borderPane1.setTop((Node)this.borderPane2);
        this.addTimerButton.setOnAction(this.actionEventHandler);
        this.addTimerButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_add_64x64.png"));
        this.hBox1.getChildren().add((Object)this.addTimerButton);
        this.editTimerButton.setOnAction(this.actionEventHandler);
        this.editTimerButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_gear_64x64.png"));
        this.hBox1.getChildren().add((Object)this.editTimerButton);
        this.deleteTimerButton.setOnAction(this.actionEventHandler);
        this.deleteTimerButton.setGraphic((Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
        this.hBox1.getChildren().add((Object)this.deleteTimerButton);
        this.hBox1.setAlignment(Pos.CENTER);
        this.borderPane2.setBottom((Node)this.hBox1);
        this.setRight((Node)this.borderPane1);
        this.setCenter((Node)this.timerTablePane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setTimer(XdtsTimer timer) throws Exception {
        this.timer = timer;
        boolean disable = false;
        if (timer == null) {
            disable = true;
        }
        this.editTimerButton.setDisable(disable);
        this.deleteTimerButton.setDisable(disable);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        String msg;
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == this.addTimerButton.hashCode()) {
            XdtsTimerTaskPane.show2(-1, this);
        } else if (ev.getSource().hashCode() == this.editTimerButton.hashCode()) {
            XdtsTimerTaskPane.show2(this.timer.getDataId(), this);
        } else if (ev.getSource().hashCode() == this.deleteTimerButton.hashCode() && FxOptionPane.showConfirmDialog((Node)this, (Object)(msg = String.format(BcWords.getInstance().Do_you_want_to_delete_the_$, this.timer.name)), BcWords.getInstance().confirmation, 3) == 0) {
            XdtsTimerTaskPane.delete(this.getScene().getWindow(), this.timer);
            this.timerTablePane.doLoad();
        }
    }

    @Override
    public void handle(BcProgressEvent updateEvent) throws Exception {
        if (BcLangUtil.isAssignableFrom(XdtsTimer.class, updateEvent.getSource())) {
            this.timerTablePane.doLoad();
        }
    }

    @Override
    public String getTitle() throws Exception {
        return XdtsWords.getInstance().task;
    }

    @Override
    public void setMenu(MenuBar menuBar) throws Exception {
    }

    @Override
    public ImageView getImageView() throws Exception {
        return FxImageHelper.createImageView_icon("schedule_64x64.png");
    }
}

