/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.dao;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xdts.model.v0001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v0001.XdtsSelectContext;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XdtsExtractionConditionDAO
extends OrmAbstractDAO<XdtsExtractionCondition> {
    public XdtsExtractionConditionDAO() {
        super(new XdtsExtractionCondition[0]);
        this.setTableName("xdts_extraction_condition");
    }

    public static XdtsExtractionConditionDAO getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public int putEntity(DtsSession dtsSession, int userId, XdtsExtractionCondition extractionCondition) throws Exception {
        int updateCnt = super.putEntity(dtsSession, userId, extractionCondition);
        if (updateCnt <= 0) {
            this.getLogger().warning("updateCnt=" + updateCnt);
            return updateCnt;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(baos);
        objectOutputStream.writeObject(extractionCondition.selectContextList);
        byte[] bytes = baos.toByteArray();
        this.getLogger().debug("bytes.length=" + bytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        String whereClause = "id = " + extractionCondition.id;
        SqlContext sqlContext = dtsSession.getSqlContext();
        int updateCnt2 = sqlContext.putBinary(dtsSession.getConnection(), this.getTableName(), "select_context_list", whereClause, bais, bytes.length);
        this.getLogger().debug("updateCnt2=" + updateCnt2);
        return updateCnt2;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, int entityId, int profileId, String entityName) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (entityId > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + entityId);
            selectQuery.addWhereElement(whereElement);
        }
        if (profileId > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "profile_id = " + profileId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(entityName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "name " + sqlContext.toCondition_string("=", entityName));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(SqlUtil.createTableName(this.getTableName(), alias));
        switch (mode) {
            case id: {
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
                break;
            }
            case profileId: {
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "profile_id");
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "name");
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
            }
        }
        String query = sqlContext.buildSelectQuery(selectQuery);
        this.getLogger().debug("query=" + query);
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, int entityId, int profileId, String entityName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "excon";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, entityId, profileId, entityName);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    @Override
    public int deleteEntity(DtsSession dtsSession, long entityId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "DELETE  FROM " + this.getTableName() + " WHERE id = " + entityId;
        this.getLogger().debug("query=" + query);
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public XdtsExtractionCondition getById(DtsSession dtsSession, int entityId) throws Exception {
        int profileId = -1;
        String entityName = null;
        List entityList = this.getList(dtsSession, Mode.id, entityId, profileId, entityName);
        XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)BcCollectionUtil.getFirst(entityList);
        if (extractionCondition != null) {
            extractionCondition.selectContextList = this.getBinary(dtsSession, extractionCondition.id);
        }
        return extractionCondition;
    }

    public <T> T getByName(DtsSession dtsSession, int profileId, String entityName) throws Exception {
        if (BcStringUtil.isEmpty(entityName)) {
            return null;
        }
        int entityId = -1;
        List<T> entityList = this.getList(dtsSession, Mode.profileId, entityId, profileId, entityName);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getList(DtsSession dtsSession, int profileId) throws Exception {
        return this.getList(dtsSession, Mode.profileId, -1, profileId, null);
    }

    public List<XdtsSelectContext> getBinary(DtsSession dtsSession, int entityId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT select_context_list FROM " + this.getTableName() + " WHERE id = " + entityId;
        this.getLogger().debug("query=" + query);
        List selectContextList = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                ObjectInputStream objis = new ObjectInputStream(rs.getBinaryStream(1));
                selectContextList = (List)objis.readObject();
            }
            rs.close();
        }
        return selectContextList;
    }

    public static enum Mode {
        id,
        profileId;

    }

    private static final class SingletonHolder {
        private static final XdtsExtractionConditionDAO instance = new XdtsExtractionConditionDAO();

        private SingletonHolder() {
        }
    }
}

