/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcRegexUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.html.util.EtcHtmlUtil;
import jp.co.extreme.html.util.HtmlToPlain;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.model.XdtsControlContext;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xmmd.common.XmmdConstants;
import jp.co.extreme.module.xmmd.model.XmmdField;
import jp.co.extreme.scf.scheduler.ScfSchedulerWords;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.SqlWords;

public final class XdtsUtil {
    static HtmlToPlain htmlToPlain = new HtmlToPlain();

    private XdtsUtil() {
    }

    public static List<XdtsSchemaObject> toSchemaObjectList(List<String> objectNameList, XdtsConstants.SchemaObjectType schemaObjectType, boolean enabled) throws Exception {
        ArrayList<XdtsSchemaObject> schemaObjectList = new ArrayList<XdtsSchemaObject>();
        int i = 0;
        while (i < objectNameList.size()) {
            XdtsSchemaObject schemaObject = new XdtsSchemaObject();
            schemaObject.schemaObjectType = schemaObjectType;
            schemaObject.name1 = objectNameList.get(i);
            schemaObject.enabled = enabled;
            schemaObjectList.add(schemaObject);
            ++i;
        }
        return schemaObjectList;
    }

    public static List<XdtsSchemaObject> toSchemaObjectList(XdtsConstants.SchemaObjectType schemaObjectType, boolean enabled, String ... shemaObjectNames) throws Exception {
        ArrayList<String> objectNameList = new ArrayList<String>();
        int i = 0;
        while (i < shemaObjectNames.length) {
            objectNameList.add(shemaObjectNames[i]);
            ++i;
        }
        return XdtsUtil.toSchemaObjectList(objectNameList, schemaObjectType, enabled);
    }

    public static BcTableColumnModel createProfileTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = SqlWords.getInstance().dataSourceName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = XdtsWords.getInstance().product;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().url;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 60;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().user;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 12;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().note;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static List<String> toNameList(List<XdtsSchemaObject> schemaObjectList) throws Exception {
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < schemaObjectList.size()) {
            XdtsSchemaObject schemaObject = schemaObjectList.get(i);
            nameList.add(schemaObject.name1);
            ++i;
        }
        return nameList;
    }

    public static BcTableColumnModel createColumnDefineTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().ordinalPosition.toPlain();
        mmdField.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().ordinalPosition);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = XmmdConstants.TableColmnName.xmmd_field__column_name.value;
        mmdField.columnName = BcWords.getInstance().columnName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 24;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = SqlWords.getInstance().jdbcType;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().size;
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().decimalDigit.toPlain();
        mmdField.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().decimalDigit);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().nullable;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 7;
        mmdField.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().logicalName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        mmdField.horizonalAlignment = 2;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createCustomQueryTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = "\u30b3\u30fc\u30c9";
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "\u30af\u30a8\u30ea";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "\u5099\u8003";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "\u767b\u9332\u65e5\u6642";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createWordTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = "<html><center>" + BcWords.getInstance().physicalName + "</center></html>";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 32;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "<html><center>" + BcWords.getInstance().language + "</center></html>";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 4;
        mmdField.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "<html><center>" + BcWords.getInstance().logicalName + "</center></html>";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 60;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().note;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createTimerTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = XdtsWords.getInstance().timerName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = String.valueOf(BcWords.getInstance().start) + " " + BcWords.getInstance().dateTime;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 17;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = ScfSchedulerWords.getInstance().trigger;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = String.valueOf(BcWords.getInstance().value) + " 1";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = String.valueOf(BcWords.getInstance().value) + " 2";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = String.valueOf(BcWords.getInstance().value) + " 3";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static String createColumnName(int columnNum) throws Exception {
        return "column_" + columnNum;
    }

    public static String toDbObjectName(String src) throws Exception {
        String tmpStr = BcStringUtil.toLatinBasic(src, 2);
        tmpStr = BcStringUtil.replace((CharSequence)tmpStr, BcStringUtil.SPACE_STR, BcStringUtil.UNDER_SCORE_STR).toString();
        tmpStr = BcStringUtil.replace((CharSequence)tmpStr, BcUnicode.FULLWIDTH_SPACE_STR, BcStringUtil.UNDER_SCORE_STR).toString();
        return tmpStr.toString();
    }

    public static BcTableColumnModel createSizeTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().tableName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 40;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().numberOfRows);
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 12;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().size;
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 8;
        mmdField.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static String apendLogicalName(DtsWordManager wordManager, String physicalName) {
        StringBuilder sb = new StringBuilder();
        sb.append(physicalName);
        String logicalName = wordManager.getWord(physicalName.toString(), Locale.getDefault().getLanguage());
        if (!BcStringUtil.isEmpty(logicalName)) {
            sb.append(" ");
            sb.append(logicalName);
        }
        return sb.toString();
    }

    public static String getLogicalName(String tableName, XmmdField xmmdField, DtsWordManager wordManager) throws Exception {
        if (wordManager == null) {
            return null;
        }
        String logicalName = null;
        if (!BcStringUtil.isEmpty(xmmdField.wordCode)) {
            logicalName = wordManager.getWord(xmmdField.wordCode, Locale.getDefault().getLanguage());
        }
        if (BcStringUtil.isEmpty(logicalName)) {
            String tableColumnName = MmdUtil.createTableColumnName(tableName, xmmdField.columnName);
            logicalName = wordManager.getWord(tableColumnName, Locale.getDefault().getLanguage());
        }
        logicalName = htmlToPlain.toPlain(logicalName).toString();
        return logicalName;
    }

    public static String getDefaultValue(XdtsControlContext controlContext, XdtsUserSetting userSetting) throws Exception {
        String defaultValue = null;
        if (BcCollectionUtil.isEmpty(controlContext.inputValueList)) {
            defaultValue = controlContext.defaultValue;
            if (!BcStringUtil.isEmpty(controlContext.name) && userSetting != null && userSetting.map.containsKey(controlContext.name)) {
                defaultValue = userSetting.map.get(controlContext.name);
            }
        } else {
            defaultValue = BcCollectionUtil.getLast(controlContext.inputValueList);
        }
        BcLogUtil.debug("getDefaultValue:defaultValue=" + defaultValue);
        return defaultValue;
    }

    public static List<String> createOptionList(XdtsControlContext controlContext) throws Exception {
        List<String> optionList = BcCsvUtil.parseCsvRow(controlContext.options, true);
        if (!BcCollectionUtil.isEmpty(optionList)) {
            return XdtsUtil.trim(optionList);
        }
        if (!BcCollectionUtil.isEmpty(controlContext.inputValueList)) {
            for (String value : controlContext.inputValueList) {
                if (BcStringUtil.isEmpty(value = BcStringUtil.trim(value)) || optionList.contains(value)) continue;
                optionList.add(value);
            }
        }
        return optionList;
    }

    public static List<String> trim(List<String> strList) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strList) {
            str = BcStringUtil.trim(str);
            list.add(str);
        }
        return list;
    }

    public static BcResult validateSql(String sql, boolean pluralOk) throws Exception {
        BcResult result = new BcResult();
        List<String> statementList = SqlUtil.toStatementList(sql);
        if (BcCollectionUtil.isEmpty(statementList)) {
            result.addError(XdtsWords.getInstance().\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u304c\u691c\u51fa\u3067\u307e\u305b\u3093);
        }
        if (!pluralOk && BcCollectionUtil.getSize(statementList) > 1) {
            result.addError(XdtsWords.getInstance().\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u304c\u8907\u6570\u3067\u3059);
        }
        return result;
    }

    public static String reformPath(String src) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            return null;
        }
        String strWk = XdtsUtil.temp1(src);
        String[] elemnts = BcStringUtil.split(strWk, BcRegexUtil.escapEncode(BcStringUtil.SLASH_STR));
        ArrayList<String> list = new ArrayList<String>();
        int j = 0;
        while (j < elemnts.length) {
            String elemnt = elemnts[j];
            if (!BcStringUtil.isEmpty(elemnt = BcStringUtil.trim(elemnt))) {
                list.add(elemnt);
            }
            ++j;
        }
        strWk = BcStringUtil.marge(list, BcStringUtil.SLASH_STR).toString();
        if (BcStringUtil.isEmpty(strWk)) {
            return null;
        }
        return strWk;
    }

    public static String deleteFirst(String str) throws Exception {
        return str.substring(1);
    }

    public static String deleteLast(String str) throws Exception {
        return str.substring(0, str.length() - 1);
    }

    public static String temp1(String src) throws Exception {
        String strWk = BcStringUtil.trim(src);
        while (strWk.startsWith(BcStringUtil.SLASH_STR)) {
            strWk = XdtsUtil.deleteFirst(strWk);
            strWk = BcStringUtil.trim(strWk);
        }
        while (strWk.endsWith(BcStringUtil.SLASH_STR)) {
            strWk = XdtsUtil.deleteLast(strWk);
            strWk = BcStringUtil.trim(strWk);
        }
        return strWk;
    }

    public static void addEntry(String key, String value, XdtsUserSetting userSetting) throws Exception {
        if (userSetting != null) {
            userSetting.addEntry(key, value);
        }
    }
}

