/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.http.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.http.HttpConstants;
import jp.co.extreme.http.HttpUtil;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;

public class HtclHttpContentLoader {
    public long connectionTimeout = 5000L;
    public long socketTimeout = 60000L;
    protected BcStreamTransmitter streamTransmitter;

    public HtclHttpContentLoader() {
        this.setStreamTransmitter(new BcStreamTransmitter());
    }

    public BcStreamTransmitter getStreamTransmitter() {
        return this.streamTransmitter;
    }

    public void setStreamTransmitter(BcStreamTransmitter streamTransmitter) {
        this.streamTransmitter = streamTransmitter;
    }

    public void loadContent(URL url, OutputStream os, long rangeStart, long rangeEnd, CredentialsProvider credsProvider) throws Exception {
        block15: {
            String userAgent = "Http Client 0.1";
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeout, TimeUnit.MILLISECONDS).setDefaultKeepAlive(this.socketTimeout, TimeUnit.MILLISECONDS).build();
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            headers.add(new BasicHeader(HttpConstants.RequestHeader.Accept_Charset.value, (Object)"utf-8"));
            headers.add(new BasicHeader(HttpConstants.RequestHeader.Accept_Language.value, (Object)"ja, en;q=0.8"));
            headers.add(new BasicHeader(HttpConstants.RequestHeader.User_Agent.value, (Object)userAgent));
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            if (credsProvider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(credsProvider);
            }
            CloseableHttpClient httpClient = httpClientBuilder.build();
            HttpGet httpGet = new HttpGet(url.toExternalForm());
            if (rangeStart >= 0L) {
                httpGet.addHeader(HttpConstants.RequestHeader.Range.value, (Object)("bytes=" + rangeStart + "-" + rangeEnd));
            }
            CloseableHttpResponse httpResponse = null;
            httpResponse = httpClient.execute((ClassicHttpRequest)httpGet);
            String contentLengtStr = HttpUtil.getHeaderValue((HttpResponse)httpResponse, "Content-Length");
            if (httpResponse.getCode() == 200 || httpResponse.getCode() == 206) {
                HttpEntity httpEntity = httpResponse.getEntity();
                InputStream is = httpEntity.getContent();
                try {
                    this.streamTransmitter.transmit(is, os);
                    break block15;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception ex) {
                            BcLogUtil.error(ex);
                        }
                    }
                }
            }
            throw new ConnectException("STATUS=" + httpResponse.getCode());
        }
    }
}

