/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.fx.util.FxUtil;

public class FxImageUtil {
    private FxImageUtil() throws Exception {
    }

    public static Rectangle2D calcKeepRatio(double srcWidth, double srcHeight, double targetWidth, double targetHeight) throws Exception {
        Rectangle2D.Double awtRectangle = AwtImageUtil.calcKeepRatioSize(srcWidth, srcHeight, targetWidth, targetHeight);
        Rectangle2D rectangle2D = FxUtil.toRectangle2D(awtRectangle);
        return rectangle2D;
    }

    public static void setSizeKeepRatio(ImageView imageView, double targetWidth, double targetHeight) throws Exception {
        Image image = imageView.getImage();
        Rectangle2D rectangle2D = FxImageUtil.calcKeepRatio(image.getWidth(), image.getHeight(), targetWidth, targetHeight);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(rectangle2D.getWidth());
    }

    public static Image extractImage(Image image, double targetWidth, double targetHeight) throws Exception {
        BufferedImage bufferedImage1 = SwingFXUtils.fromFXImage((Image)image, null);
        if (bufferedImage1 == null) {
            String msg = "FX\u30a4\u30e1\u30fc\u30b8\u304b\u3089 java.awt.image.BufferedImage \u3078\u306e\u5909\u63db\u306b\u304a\u3044\u3066\u4f8b\u5916";
            throw new Exception(msg);
        }
        BufferedImage bufferedImage2 = AwtImageUtil.extractImage(bufferedImage1, targetWidth, targetHeight);
        WritableImage image2 = SwingFXUtils.toFXImage((BufferedImage)bufferedImage2, null);
        return image2;
    }

    public static void setSizeExtract(ImageView imageView, double targetWidth, double targetHeight) throws Exception {
        Image image2 = FxImageUtil.extractImage(imageView.getImage(), targetWidth, targetHeight);
        imageView.setImage(image2);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(targetWidth);
    }
}

