/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.fx.util.FxUtil;

public class FxImageHelper {
    private static Image stageIconImage;
    private static Map<String, Image> imageMap;

    static {
        imageMap = new HashMap<String, Image>();
    }

    private FxImageHelper() throws Exception {
    }

    public static Image getImage(String name) throws Exception {
        Image image = imageMap.get(name);
        if (image == null) {
            BufferedImage awtImage = AwtImageHelper.getImage(name);
            BufferedImage bufferedImage = null;
            bufferedImage = awtImage instanceof BufferedImage ? awtImage : AwtImageUtil.toBufferedImage(awtImage);
            image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        }
        return image;
    }

    public static ImageView createImageView_icon(String name) throws Exception {
        Image image = FxImageHelper.getImage(name);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(16.0);
        return imageView;
    }

    public static Image getStageIcon() {
        return stageIconImage;
    }

    public static void setStageIcon(Stage stage) throws Exception {
        if (stageIconImage == null) {
            BufferedImage awtImage = AwtImageHelper.getWindowIconImage();
            stageIconImage = FxUtil.convImage(awtImage);
        }
        if (stageIconImage != null) {
            stage.getIcons().add((Object)stageIconImage);
        }
    }
}

