/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.skin;

import java.io.InputStream;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.net.BcURLStreamHandler;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.skin.FxSkinUtil;
import jp.co.extreme.fx.util.FxColorUtil;
import jp.co.extreme.fx.util.FxEffectUtil;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.swing.SwgTableViewUtil;

public class FxSkinDefault {
    public static final String $_baseBg = "${baseBg}";
    public static final String $_baseBgDark = "${baseBgDark}";
    public static final String $_baseBgBright = "${baseBgBright}";
    public static final String $_fontSize1 = "${fontSize1}";
    public static final String $_fontFamily1 = "${fontFamily1}";
    public static final String $_fontName1 = "${fontName1}";
    public static final String $_fontWeight1 = "${fontWeight1}";
    public static final String $_labelFg = "${labelFg}";
    public static final String $_textFieldBg = "${textFieldBg}";
    public static final String $_textFieldFg = "${textFieldFg}";
    public static final String $_textFieldReadonlyBg = "${textFieldReadonlyBg}";
    public static final String $_textFieldEffect = "${textFieldEffect}";
    public static final String $_buttonBg = "${buttonBg}";
    public static final String $_tableGridColor = "${tableGridColor}";
    public static final String $_tableHeaderBg = "${tableHeaderBg}";
    public static final String $_tableHeaderFg = "${tableHeaderFg}";
    public static final String $_tableRowOddBg = "${tableRowOddBg}";
    public static final String $_tableRowEvenBg = "${tableRowEvenBg}";
    public static final String $_tableRowSelectedBg = "${tableRowSelectedBg}";
    public static final String $_tableRowSelectedFg = "${tableRowSelectedFg}";
    public static final String $_tableRowHoverBg = "${tableRowHoverBg}";
    private Color baseBg;
    private Color baseBgDark;
    private Color baseBgBright;
    private Color textColor;
    private Color textFieldReadonlyBg = Color.web((String)"#DADADA");
    double textFieldOpacity = 1.0;
    double tableOpacity = 0.6;

    public Color getBaseColor1() throws Exception {
        if (this.baseBg == null) {
            this.baseBg = FxSkinUtil.getColorByKey("Panel.background");
        }
        return this.baseBg;
    }

    public Color getBaseDarkColor() throws Exception {
        if (this.baseBgDark == null) {
            this.baseBgDark = FxColorUtil.colorChange(this.getBaseColor1(), -10);
        }
        return this.baseBgDark;
    }

    public Color getBaseBrightColor() throws Exception {
        if (this.baseBgBright == null) {
            Color tmpColor = FxSkinUtil.getColorByKey("Panel.background");
            this.baseBgBright = FxColorUtil.colorChange(this.getBaseColor1(), 15);
        }
        return this.baseBgBright;
    }

    public Color getTextColor() throws Exception {
        if (this.textColor == null) {
            this.textColor = FxSkinUtil.getColorByKey("Panel.foreground");
        }
        return this.textColor;
    }

    public Color getTextFieldReadonlyBg() throws Exception {
        return this.textFieldReadonlyBg;
    }

    public void setStyle(Node node) throws Exception {
        block23: {
            block21: {
                TitledPane titledPane;
                block22: {
                    if (!(node instanceof Labeled)) break block21;
                    if (!(node instanceof ButtonBase)) break block22;
                    if (!(node instanceof CheckBox)) {
                        ButtonBase buttonBase = (ButtonBase)node;
                        buttonBase.setEffect((Effect)FxEffectUtil.createDropShadowForButton());
                    }
                    break block23;
                }
                if (!(node instanceof TitledPane) || (titledPane = (TitledPane)node).getContent() == null) break block23;
                this.setStyle(titledPane.getContent());
                break block23;
            }
            if (node instanceof TextField) {
                TextField textField = (TextField)node;
                FxCssUtil.setStyle_form_01((TextInputControl)textField);
            } else if (node instanceof TextArea) {
                TextArea textArea = (TextArea)node;
                FxCssUtil.setStyle_form_01((TextInputControl)textArea);
            } else if (node instanceof PasswordField) {
                PasswordField passwordField = (PasswordField)node;
                FxCssUtil.setStyle_form_01((TextInputControl)passwordField);
            } else if (node instanceof ComboBox) {
                ComboBox passwordField = (ComboBox)node;
            } else if (node instanceof FxFlowPane) {
                FxFlowPane flowPane = (FxFlowPane)node;
                this.setStyle_NodeUnit(flowPane.nodeUnitList);
            } else if (node instanceof Pane) {
                Pane pane = (Pane)node;
                this.setStyle((Collection<? extends Node>)pane.getChildren());
            } else if (node instanceof ScrollPane) {
                ScrollPane scrollPane = (ScrollPane)node;
                if (scrollPane.getContent() != null) {
                    this.setStyle(scrollPane.getContent());
                }
            } else if (node instanceof SplitPane) {
                SplitPane splitPane = (SplitPane)node;
                this.setStyle((Collection<? extends Node>)splitPane.getItems());
            } else if (node instanceof TabPane) {
                TabPane tabPane = (TabPane)node;
                ObservableList tabList = tabPane.getTabs();
                int i = 0;
                while (i < tabList.size()) {
                    Tab tab = (Tab)tabList.get(i);
                    if (tab.getContent() != null) {
                        this.setStyle(tab.getContent());
                    }
                    ++i;
                }
            }
        }
    }

    public void setStyle(Collection<? extends Node> nodeCollection) throws Exception {
        for (Node node : nodeCollection) {
            this.setStyle(node);
        }
    }

    public void setStyle(FxNodeUnit nodeUnit) throws Exception {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            this.setStyle(leftNode);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            if (rightNode != null) {
                this.setStyle(rightNode);
            }
            ++i;
        }
    }

    public void setStyle_NodeUnit(Collection<? extends FxNodeUnit> nodeUnitCollection) throws Exception {
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            this.setStyle(fxNodeUnit);
        }
    }

    protected StringBuilder convCss(byte[] bytes) throws Exception {
        StringBuilder css = new StringBuilder(new String(bytes));
        css = BcStringUtil.replace((CharSequence)css, $_baseBg, FxCssUtil.toRgba(this.getBaseColor1()));
        css = BcStringUtil.replace((CharSequence)css, $_baseBgDark, FxCssUtil.toRgba(this.getBaseDarkColor()));
        css = BcStringUtil.replace((CharSequence)css, $_baseBgBright, FxCssUtil.toRgba(this.getBaseBrightColor()));
        Font defaultFont = FxFontUtil.getDefaultFont();
        css = BcStringUtil.replace((CharSequence)css, $_fontSize1, "9pt");
        css = BcStringUtil.replace((CharSequence)css, $_fontFamily1, FxFontUtil.defaultFontName);
        css = BcStringUtil.replace((CharSequence)css, $_fontName1, FxFontUtil.defaultFontName);
        css = BcStringUtil.replace((CharSequence)css, $_fontWeight1, FxFontUtil.defaultFontWeight.name());
        Color labelFg = FxSkinUtil.getColorByKey("Label.foreground");
        css = BcStringUtil.replace((CharSequence)css, $_labelFg, FxCssUtil.toRgba(labelFg));
        Color textFieldBg = Color.WHITE;
        textFieldBg = FxColorUtil.setOpacity(textFieldBg, this.textFieldOpacity);
        css = BcStringUtil.replace((CharSequence)css, $_textFieldBg, FxCssUtil.toRgba(textFieldBg));
        Color textFieldFg = Color.BLACK;
        css = BcStringUtil.replace((CharSequence)css, $_textFieldFg, FxCssUtil.toRgba(textFieldFg));
        css = BcStringUtil.replace((CharSequence)css, $_textFieldReadonlyBg, FxCssUtil.toRgba(this.textFieldReadonlyBg));
        css = BcStringUtil.replace((CharSequence)css, $_textFieldEffect, FxCssUtil.createInnershadow());
        css = BcStringUtil.replace((CharSequence)css, $_buttonBg, "linear-gradient(#aaaaaa, #999999)");
        css = this.conv_table(css);
        return css;
    }

    protected StringBuilder conv_table(StringBuilder css) throws Exception {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        Object value = uiDefaults.get("Table.background");
        if (value == null) {
            value = java.awt.Color.BLACK;
        }
        java.awt.Color tableBg = (java.awt.Color)value;
        Color tempColor = FxSkinUtil.getColorByKey("Table.gridColor");
        tempColor = Color.WHITE;
        tempColor = FxColorUtil.setOpacity(tempColor, this.tableOpacity);
        css = BcStringUtil.replace((CharSequence)css, $_tableGridColor, FxCssUtil.toRgba(tempColor));
        tempColor = FxSkinUtil.getColorByKey("TableHeader.background");
        tempColor = FxColorUtil.setOpacity(tempColor, this.tableOpacity);
        css = BcStringUtil.replace((CharSequence)css, $_tableHeaderBg, FxCssUtil.toRgba(tempColor));
        tempColor = FxSkinUtil.getColorByKey("TableHeader.foreground");
        css = BcStringUtil.replace((CharSequence)css, $_tableHeaderFg, FxCssUtil.toRgba(tempColor));
        tempColor = FxColorUtil.convFromAwt(SwgTableViewUtil.toRowOddBg(tableBg));
        tempColor = FxColorUtil.setOpacity(tempColor, this.tableOpacity);
        css = BcStringUtil.replace((CharSequence)css, $_tableRowOddBg, FxCssUtil.toRgba(tempColor));
        tempColor = FxColorUtil.convFromAwt(SwgTableViewUtil.toRowEvenBg(tableBg));
        tempColor = FxColorUtil.setOpacity(tempColor, this.tableOpacity);
        css = BcStringUtil.replace((CharSequence)css, $_tableRowEvenBg, FxCssUtil.toRgba(tempColor));
        tempColor = Color.web((String)"#b0e0e6");
        tempColor = FxColorUtil.setOpacity(tempColor, this.tableOpacity);
        css = BcStringUtil.replace((CharSequence)css, $_tableRowSelectedBg, FxCssUtil.toRgba(tempColor));
        tempColor = FxSkinUtil.getColorByKey("Table.focusCellForeground");
        css = BcStringUtil.replace((CharSequence)css, $_tableRowSelectedFg, FxCssUtil.toRgba(tempColor));
        tempColor = Color.LIGHTSLATEGRAY;
        tempColor = FxColorUtil.setOpacity(tempColor, this.tableOpacity);
        css = BcStringUtil.replace((CharSequence)css, $_tableRowHoverBg, FxCssUtil.toRgba(tempColor));
        return css;
    }

    public void setCss(Scene scene) throws Exception {
        String dir = null;
        dir = BcRuntimeUtil.isJava_1_8() ? "css_v1_8" : "css_v1_8";
        this.setCss(scene, dir, "base.css");
        this.setCss(scene, dir, "tableView.css");
        this.setCss(scene, dir, "treeView.css");
        this.setCss(scene, dir, "tab.css");
        this.setCss(scene, dir, "contextMenu.css");
    }

    protected void setCss(Scene scene, String dir, String fileName) throws Exception {
        String url = "internal:" + fileName;
        String path = String.valueOf(dir) + "/" + fileName;
        InputStream is = FxSkinDefault.class.getResourceAsStream(path);
        byte[] bytes = BcStreamUtil.readWithClose(is);
        if (bytes == null) {
            BcLogUtil.warning("bytes is null. path=" + path);
            return;
        }
        StringBuilder css = this.convCss(bytes);
        BcURLStreamHandler.getInstance().map.put(fileName, css.toString().getBytes());
        scene.getStylesheets().add((Object)url);
    }
}

