/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx;

import java.util.Collection;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxxRadioButtonControl;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;

public class FxxRadioButtonPane
extends FxDecoratePane {
    protected Pane leftPane = new Pane();
    protected FxxRadioButtonControl radioButtonControl = new FxxRadioButtonControl(false);
    protected FxButton selectButton;
    protected FxButton closeButton;
    protected boolean isSelected;
    protected String selectedValue;
    protected Stage stage;

    public FxxRadioButtonPane() throws Exception {
        this.closeButton = this.createButton(BcWords.getInstance().close);
        this.selectButton = this.createButton(BcWords.getInstance().select);
        this.leftPane.setPrefWidth(40.0);
        this.setLeft((Node)this.leftPane);
        this.setCenter((Node)this.radioButtonControl);
    }

    public void setData(Collection<String> keyCollection) throws Exception {
        this.radioButtonControl.setData2(keyCollection);
    }

    public String getSelectedValue() throws Exception {
        return this.selectedValue;
    }

    public void setSelectedValue(String selectedValue) throws Exception {
        this.selectedValue = selectedValue;
        this.radioButtonControl.setInputText(selectedValue);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.selectButton) {
            this.selectedValue = this.radioButtonControl.getInputText();
            this.isSelected = true;
            this.close();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public boolean show(Window ownerWindow, double width, double height, String title) throws Exception {
        this.isSelected = false;
        if (this.stage != null) {
            throw new Exception("aaa");
        }
        FxScene scene = new FxScene((Parent)this);
        this.stage = new FxStage();
        this.stage.setScene((Scene)scene);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    FxxRadioButtonPane.this.close();
                }
                catch (Exception ex) {
                    FxxRadioButtonPane.this.handleException(ex);
                }
            }
        });
        this.stage.setWidth(width);
        this.stage.setHeight(height);
        this.stage.setResizable(true);
        this.stage.setTitle(title);
        Image image = FxImageHelper.getImage("document_64x64.png");
        this.stage.getIcons().add((Object)image);
        this.stage.showAndWait();
        return this.isSelected;
    }
}

