/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.etc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.etc.util.EtcEnumStrUtil;

public class EtcWordUtil {
    private EtcWordUtil() throws Exception {
    }

    public static List<String> createNewList(List<String> dataList) throws Exception {
        ArrayList<String> newList = new ArrayList<String>();
        int i = 0;
        while (i < dataList.size()) {
            String str = dataList.get(i);
            if (!BcStringUtil.isEmpty(str = BcStringUtil.trim(str))) {
                newList.add(str);
            }
            ++i;
        }
        return newList;
    }

    public static String getBaseName(String origName, String subscriptStart, String subscriptEnd) throws Exception {
        if (BcStringUtil.isEmpty(origName)) {
            return null;
        }
        if (!origName.endsWith(subscriptEnd)) {
            return null;
        }
        String str1 = origName.substring(0, origName.length() - 1);
        int lastIndex = str1.lastIndexOf(subscriptStart);
        if (lastIndex < 0) {
            return null;
        }
        String str2 = str1.substring(lastIndex + 1);
        try {
            long l = Long.parseLong(str2);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            return null;
        }
        String baseName = str1.substring(0, lastIndex);
        return baseName;
    }

    public static String getBaseName(String origName) throws Exception {
        return EtcWordUtil.getBaseName(origName, EtcEnumStrUtil.STRAT, EtcEnumStrUtil.END);
    }

    public static void setWordCollection(DtsWordManager wordManager, Collection<EtcWord> wordCollection) throws Exception {
        for (EtcWord word : wordCollection) {
            wordManager.putWord(word.code, word.lang, word.value);
        }
    }
}

