/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.print.attribute.standard.MediaSize;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.doc.util.DcfConstants;
import jp.co.extreme.doc.util.DcfPageReader;
import jp.co.extreme.doc.util.DcfPageWriter;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfPageFormat;

public final class DcfBookUtil {
    private DcfBookUtil() {
    }

    public static void setFormatedDimension(double width, double height, PageFormat pageFormat, Dimension dim) throws Exception {
        if (pageFormat.getOrientation() == 0) {
            dim.setSize((int)height, (int)width);
        } else if (pageFormat.getOrientation() == 1) {
            dim.setSize((int)width, (int)height);
        }
    }

    public static Dimension toDimension(double width, double height, PageFormat pageFormat) throws Exception {
        Dimension dim = new Dimension();
        DcfBookUtil.setFormatedDimension(width, height, pageFormat, dim);
        return dim;
    }

    public static Dimension toDimension(PageFormat pageFormat) throws Exception {
        return DcfBookUtil.toDimension(pageFormat.getWidth(), pageFormat.getHeight(), pageFormat);
    }

    public static double getWidth(PageFormat pageFormat) throws Exception {
        double width = 0.0;
        if (pageFormat.getOrientation() == 0) {
            width = pageFormat.getHeight();
        } else if (pageFormat.getOrientation() == 1) {
            width = pageFormat.getWidth();
        }
        return width;
    }

    public static double getHeight(PageFormat pageFormat) throws Exception {
        double height = 0.0;
        if (pageFormat.getOrientation() == 0) {
            height = pageFormat.getWidth();
        } else if (pageFormat.getOrientation() == 1) {
            height = pageFormat.getHeight();
        }
        return height;
    }

    public static boolean isSameSize(PageFormat pageFormat1, PageFormat pageFormat2) throws Exception {
        Dimension dim1 = DcfBookUtil.toDimension(pageFormat1);
        Dimension dim2 = DcfBookUtil.toDimension(pageFormat2);
        return dim1.equals(dim2);
    }

    public static Object[] createAffineTransform(MediaSize mediaSize, PageFormat pageFormat, int dpi) throws Exception {
        Dimension pixelDim = AwtImageUtil.calcPixelDimension(mediaSize, dpi);
        pixelDim = DcfBookUtil.toDimension(pixelDim.width, pixelDim.height, pageFormat);
        double scale = (double)pixelDim.width / pageFormat.getWidth();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(scale, scale);
        Object[] res = new Object[]{pixelDim, affineTransform};
        return res;
    }

    public static BufferedImage createImage(DcfPage dcfPage, int imageType, int dpi, DcfShapeRenderer shapeRenderer) throws Exception {
        MediaSize mediaSize = dcfPage.getMediaSize();
        DcfPageFormat pageFormat = dcfPage.getPageFormat();
        Object[] values = DcfBookUtil.createAffineTransform(mediaSize, pageFormat, dpi);
        Dimension pixelDim = (Dimension)values[0];
        AffineTransform affineTransform = (AffineTransform)values[1];
        BufferedImage bufferedImage = new BufferedImage(pixelDim.width, pixelDim.height, imageType);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (dcfPage.paperColor != null) {
            g2d.setColor(dcfPage.paperColor);
        } else {
            g2d.setColor(DcfConstants.DEFAULT_PAPER_COLOR);
        }
        g2d.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        g2d.setTransform(affineTransform);
        shapeRenderer.drawPage(g2d, pageFormat.getImageableX(), pageFormat.getImageableY(), dcfPage);
        return bufferedImage;
    }

    public static void marge(DcfPageWriter pageWriter, DcfPageReader pageReader) throws Exception {
        int i = 0;
        while (i < pageReader.getPageCount()) {
            DcfPage dcfPage = pageReader.getPage(i);
            pageWriter.addPage(dcfPage);
            ++i;
        }
    }

    public static DcfBook marge(Collection<? extends DcfPageReader> pageReaderCollection) throws Exception {
        DcfBook dcfBook = new DcfBook();
        for (DcfPageReader dcfPageReader : pageReaderCollection) {
            DcfBookUtil.marge(dcfBook, dcfPageReader);
        }
        return dcfBook;
    }

    public static DcfBook marge(DcfPageReader ... pageReaders) throws Exception {
        List<DcfPageReader> pageReaderList = Arrays.asList(pageReaders);
        return DcfBookUtil.marge(pageReaderList);
    }
}

