/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.text.StringEscapeUtils;

public class BcCsvUtil {
    private static CSVFormat csvFormat_RFC4180;

    private BcCsvUtil() {
    }

    public static CSVFormat getCsvFormat_RFC4180() throws Exception {
        if (csvFormat_RFC4180 != null) {
            return csvFormat_RFC4180;
        }
        CSVFormat.Builder formatBuilder = CSVFormat.RFC4180.builder();
        formatBuilder.setSkipHeaderRecord(false);
        csvFormat_RFC4180 = formatBuilder.build();
        return csvFormat_RFC4180;
    }

    public static List<String> parseCsvRow(String csvRow, boolean emptyEnable) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        if (BcStringUtil.isEmpty(csvRow)) {
            if (emptyEnable) {
                return valueList;
            }
            throw new Exception("csvRow=" + csvRow);
        }
        CharArrayReader charArrayReader = new CharArrayReader(csvRow.toCharArray());
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        CSVFormat csvFormat = BcCsvUtil.getCsvFormat_RFC4180();
        CSVParser csvRecords = csvFormat.parse((Reader)bufferedReader);
        Iterator iterator = csvRecords.iterator();
        if (iterator.hasNext()) {
            CSVRecord csvRecord = (CSVRecord)iterator.next();
            int i = 0;
            while (i < csvRecord.size()) {
                String value = csvRecord.get(i);
                valueList.add(value);
                ++i;
            }
        }
        return valueList;
    }

    public static String toCsv(Collection collection, boolean doEescape, String delimiter) {
        ArrayList<String> newList = new ArrayList<String>();
        for (Object object : collection) {
            String str = BcStringUtil.toString(object);
            if (doEescape && str != null) {
                str = StringEscapeUtils.escapeCsv((String)str);
            }
            newList.add(str);
        }
        return BcStringUtil.marge(newList, delimiter).toString();
    }

    public static String toCsv(Collection collection, boolean doEescape) {
        return BcCsvUtil.toCsv(collection, doEescape, BcStringUtil.COMMA_STR);
    }

    public static String toCsv(Collection collection) {
        return BcCsvUtil.toCsv(collection, true);
    }

    public static String toCsv(String ... strings) {
        return BcCsvUtil.toCsv(Arrays.asList(strings), true);
    }

    public static int getElementIndex(String csvRow, Object element) throws Exception {
        List<String> elementList = BcCsvUtil.parseCsvRow(csvRow, true);
        int i = 0;
        while (i < elementList.size()) {
            String element2 = elementList.get(i);
            if (element.toString().equals(element2)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean hasElement(String csvRow, Object element) throws Exception {
        return BcCsvUtil.getElementIndex(csvRow, element) >= 0;
    }
}

