/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import jp.co.extreme.base.core.BcByteUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.runtime.BcOverflowException;
import jp.co.extreme.base.util.BcCompareUtil;

public final class BcNumberUtil {
    public static final int groupingSize = 3;
    public static final DecimalFormatSymbols decimalFormatSymbols;
    public static final char groupingSeparator;
    public static final DecimalFormat decimalFormat;
    public static final char pointChar = '.';
    public static final String pointStr;
    public static final String PLUS;
    public static final String MINUS;
    public static final char EXPONENT_CHAR = 'E';

    static {
        pointStr = Character.toString('.');
        PLUS = BcStringUtil.PLUS_STR;
        MINUS = BcStringUtil.HYPHEN_STR;
        decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        groupingSeparator = decimalFormatSymbols.getGroupingSeparator();
        decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingSize(3);
    }

    private BcNumberUtil() {
    }

    public static Number toNumber(String src, Class toClass) {
        String numStr = BcNumberUtil.numberPreParse(src);
        if (toClass == Byte.class) {
            return Byte.valueOf(numStr);
        }
        if (toClass == Short.class) {
            return Short.valueOf(numStr);
        }
        if (toClass == Integer.class) {
            return Integer.valueOf(numStr);
        }
        if (toClass == Long.class) {
            return Long.valueOf(numStr);
        }
        if (toClass == Float.class) {
            return Float.valueOf(numStr);
        }
        if (toClass == Double.class) {
            return Double.valueOf(numStr);
        }
        if (toClass == BigDecimal.class) {
            return new BigDecimal(numStr);
        }
        return null;
    }

    public static Number toNumber(BigDecimal bigDecimal, Class toClass) {
        if (toClass == Byte.class) {
            return bigDecimal.byteValue();
        }
        if (toClass == Short.class) {
            return bigDecimal.shortValue();
        }
        if (toClass == Integer.class) {
            return bigDecimal.intValue();
        }
        if (toClass == Long.class) {
            return bigDecimal.longValue();
        }
        if (toClass == Float.class) {
            return Float.valueOf(bigDecimal.floatValue());
        }
        if (toClass == Double.class) {
            return bigDecimal.doubleValue();
        }
        if (toClass == BigDecimal.class) {
            return BcNumberUtil.clone(bigDecimal);
        }
        return null;
    }

    public static Exception createOverflowException(Class fromClass, Class toClass, Number number) throws Exception {
        String msg = String.valueOf(fromClass.getSimpleName()) + ":" + number + " -> " + toClass.getSimpleName();
        BcOverflowException exception = new BcOverflowException(msg);
        return exception;
    }

    public static Byte toByte(Number number) throws Exception {
        int value;
        if (number == null) {
            return null;
        }
        Class<?> fromClass = number.getClass();
        Class<Byte> toClass = Byte.class;
        int minValue = -128;
        int maxValue = 127;
        if (Integer.class.equals(fromClass) ? minValue > (value = number.intValue()) || maxValue < value : (Long.class.equals(fromClass) ? (long)minValue > (value = number.longValue()) || (long)maxValue < value : (Short.class.equals(fromClass) ? minValue > (value = number.shortValue()) || maxValue < value : (Double.class.equals(fromClass) ? (double)minValue > (value = number.doubleValue()) || (double)maxValue < value : Float.class.equals(fromClass) && ((float)minValue > (value = number.floatValue()) || (float)maxValue < value))))) {
            throw BcNumberUtil.createOverflowException(fromClass, toClass, number);
        }
        return number.byteValue();
    }

    public static Short toShort(Number number) throws Exception {
        int value;
        if (number == null) {
            return null;
        }
        Class<?> fromClass = number.getClass();
        Class<Short> toClass = Short.class;
        int minValue = Short.MIN_VALUE;
        int maxValue = Short.MAX_VALUE;
        if (Integer.class.equals(fromClass) ? minValue > (value = number.intValue()) || maxValue < value : (Long.class.equals(fromClass) ? (long)minValue > (value = number.longValue()) || (long)maxValue < value : (Double.class.equals(fromClass) ? (double)minValue > (value = number.doubleValue()) || (double)maxValue < value : Float.class.equals(fromClass) && ((float)minValue > (value = number.floatValue()) || (float)maxValue < value)))) {
            throw BcNumberUtil.createOverflowException(fromClass, toClass, number);
        }
        return number.shortValue();
    }

    public static Integer toInteger(Number number) throws Exception {
        long value;
        if (number == null) {
            return null;
        }
        Class<?> fromClass = number.getClass();
        Class<Integer> toClass = Integer.class;
        int minValue = Integer.MIN_VALUE;
        int maxValue = Integer.MAX_VALUE;
        if (Long.class.equals(fromClass) ? (long)minValue > (value = number.longValue()) || (long)maxValue < value : (Double.class.equals(fromClass) ? (double)minValue > (value = number.doubleValue()) || (double)maxValue < value : Float.class.equals(fromClass) && ((float)minValue > (value = number.floatValue()) || (float)maxValue < value))) {
            throw BcNumberUtil.createOverflowException(fromClass, toClass, number);
        }
        return number.intValue();
    }

    public static Long toLong(Number number) throws Exception {
        double value;
        if (number == null) {
            return null;
        }
        Class<?> fromClass = number.getClass();
        Class<Long> toClass = Long.class;
        long minValue = Long.MIN_VALUE;
        long maxValue = Long.MAX_VALUE;
        if (Double.class.equals(fromClass) ? (double)minValue > (value = number.doubleValue()) || (double)maxValue < value : Float.class.equals(fromClass) && ((float)minValue > (value = number.floatValue()) || (float)maxValue < value)) {
            throw BcNumberUtil.createOverflowException(fromClass, toClass, number);
        }
        return number.longValue();
    }

    public static Float toFloat(Number number) throws Exception {
        double value;
        if (number == null) {
            return null;
        }
        Class<?> fromClass = number.getClass();
        Class<Float> toClass = Float.class;
        float minValue = Float.MIN_VALUE;
        float maxValue = Float.MAX_VALUE;
        if (Double.class.equals(fromClass) && ((double)minValue > (value = number.doubleValue()) || (double)maxValue < value)) {
            throw BcNumberUtil.createOverflowException(fromClass, toClass, number);
        }
        return Float.valueOf(number.floatValue());
    }

    public static Byte parseByte(String src) {
        return Byte.decode(BcNumberUtil.numberPreParse(src));
    }

    public static Byte parseByte(Object src, Byte defaultValue) {
        try {
            return BcNumberUtil.parseByte(src.toString());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Short parseShort(String src) {
        return Short.decode(BcNumberUtil.numberPreParse(src));
    }

    public static Short parseShort(Object src, Number defaultValue) {
        try {
            return BcNumberUtil.parseShort(src.toString());
        }
        catch (Exception ex) {
            if (defaultValue != null) {
                return defaultValue.shortValue();
            }
            return null;
        }
    }

    public static Integer parseInteger(String src) {
        return Integer.decode(BcNumberUtil.numberPreParse(src));
    }

    public static Integer parseInteger(Object src, Integer defaultValue) {
        try {
            return BcNumberUtil.parseInteger(src.toString());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static int parseInt(String src, int defaultValue) {
        try {
            return BcNumberUtil.parseInteger(src);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static int parseInt(String src) {
        return BcNumberUtil.parseInteger(src);
    }

    public static Long parseLong(String src) {
        return Long.decode(BcNumberUtil.numberPreParse(src));
    }

    public static Long parseLong(Object src, Number defaultValue) {
        try {
            return BcNumberUtil.parseLong(src.toString());
        }
        catch (Exception ex) {
            if (defaultValue != null) {
                return defaultValue.longValue();
            }
            return null;
        }
    }

    public static Float parseFloat(String src) {
        Double doubleValue = BcNumberUtil.parseDouble(src);
        return Float.valueOf(doubleValue.floatValue());
    }

    public static Float parseFloat(Object src, Integer scale, Number defaultValue) {
        try {
            BigDecimal bigDec = BcNumberUtil.parseBigDecimal(src.toString());
            if (scale != null) {
                bigDec = bigDec.setScale((int)scale, 4);
            }
            return Float.valueOf(bigDec.floatValue());
        }
        catch (Exception ex) {
            if (defaultValue != null) {
                return Float.valueOf(defaultValue.floatValue());
            }
            return null;
        }
    }

    public static Double parseDouble(String src) {
        return Double.parseDouble(BcNumberUtil.numberPreParse(src));
    }

    public static Double parseDouble(Object src, Integer scale, Number defaultValue) {
        try {
            BigDecimal bigDec = BcNumberUtil.parseBigDecimal(src.toString());
            if (scale != null) {
                bigDec = bigDec.setScale((int)scale, 4);
            }
            return bigDec.doubleValue();
        }
        catch (Exception ex) {
            if (defaultValue != null) {
                return defaultValue.doubleValue();
            }
            return null;
        }
    }

    public static Double parseDouble(Object src, Number defaultValue) {
        return BcNumberUtil.parseDouble(src, null, defaultValue);
    }

    public static BigDecimal parseBigDecimal(String src) throws Exception {
        Double doubleValue = BcNumberUtil.parseDouble(src);
        BigDecimal bigDec = BigDecimal.valueOf(doubleValue);
        if (BcNumberUtil.isInteger(bigDec)) {
            bigDec = bigDec.setScale(0);
        }
        return bigDec;
    }

    public static BigDecimal toBigDecimal(String src, Integer scale, Integer shift) throws Exception {
        BigDecimal bigDec = BcNumberUtil.parseBigDecimal(src);
        if (shift != null && shift != 0) {
            bigDec = bigDec.movePointLeft(shift);
        }
        if (scale != null) {
            bigDec = bigDec.setScale((int)scale, 4);
        }
        return bigDec;
    }

    public static BigDecimal toBigDecimal(String src, Integer scale) throws Exception {
        return BcNumberUtil.toBigDecimal(src, scale, null);
    }

    public static BigDecimal toBigDecimal(BigDecimal bigDec, Number defaultValue) throws Exception {
        if (bigDec != null) {
            return bigDec;
        }
        return new BigDecimal(defaultValue.toString());
    }

    public static BigDecimal toBigDecimal2(String src, int integerPartDigit, int decimalDigit, int roundingMode) throws Exception {
        BigDecimal bigDec = BcNumberUtil.parseBigDecimal(src);
        if (decimalDigit >= 0) {
            bigDec = bigDec.setScale(decimalDigit, roundingMode);
        }
        if (integerPartDigit > 0) {
            int pointPos = bigDec.toString().indexOf(pointStr);
            String upper = null;
            String lower = null;
            if (pointPos >= 0) {
                upper = bigDec.toString().substring(0, pointPos);
                lower = bigDec.toString().substring(pointPos);
            } else {
                upper = bigDec.toString();
                lower = "";
            }
            if (upper.length() > integerPartDigit) {
                upper = upper.substring(upper.length() - integerPartDigit);
            }
            bigDec = new BigDecimal(String.valueOf(upper) + lower);
        }
        return bigDec;
    }

    public static boolean isInteger(BigDecimal bigDec) throws Exception {
        BigDecimal decimal = bigDec.remainder(BigDecimal.ONE);
        return decimal.doubleValue() == 0.0;
    }

    public static String numberPreParse(String src) {
        if (BcStringUtil.isEmpty(src)) {
            return null;
        }
        StringBuilder sb = BcStringUtil.replace((CharSequence)BcStringUtil.trim(src), Character.toString(decimalFormatSymbols.getGroupingSeparator()), null);
        if (BcStringUtil.isEmpty(sb)) {
            return null;
        }
        if (sb.length() > 1 && (src.charAt(0) == '0' ? src.charAt(1) == 'x' || src.charAt(1) == 'X' : src.charAt(0) == '#')) {
            return sb.toString();
        }
        int pos = -1;
        int count = 0;
        char aChar = '\u0000';
        while (++pos < sb.length() && (aChar = src.charAt(pos)) == '0') {
            ++count;
        }
        if (count > 0) {
            if (count < sb.length()) {
                sb.delete(0, count);
            } else {
                sb.delete(0, count - 1);
            }
        }
        return sb.toString();
    }

    public static int min(int ... values) {
        int resValue = Integer.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            resValue = Math.min(resValue, values[i]);
            ++i;
        }
        return resValue;
    }

    public static double min(double ... values) {
        double resValue = Double.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            resValue = Math.min(resValue, values[i]);
            ++i;
        }
        return resValue;
    }

    public static int max(int ... values) {
        int resValue = Integer.MIN_VALUE;
        int i = 0;
        while (i < values.length) {
            resValue = Math.max(resValue, values[i]);
            ++i;
        }
        return resValue;
    }

    public static double maxDouble(double ... values) {
        double resValue = Double.MIN_VALUE;
        int i = 0;
        while (i < values.length) {
            resValue = Math.max(resValue, values[i]);
            ++i;
        }
        return resValue;
    }

    public static int sumInteger(Integer ... values) {
        int resValue = 0;
        int i = 0;
        while (i < values.length) {
            resValue += values[i].intValue();
            ++i;
        }
        return resValue;
    }

    public static double sumDouble(Double ... values) {
        double sumValue = 0.0;
        int i = 0;
        while (i < values.length) {
            sumValue += values[i].doubleValue();
            ++i;
        }
        return sumValue;
    }

    public static int[] toPrimitive(Integer ... values) {
        int[] resValue = new int[values.length];
        int i = 0;
        while (i < values.length) {
            resValue[i] = BcNumberUtil.toPrimitive(values[i]);
            ++i;
        }
        return resValue;
    }

    public static int toPrimitive(Integer values) {
        int resValue = 0;
        if (values != null) {
            resValue = values;
        }
        return resValue;
    }

    public static double[] toPrimitive(Double ... values) {
        double[] resValue = new double[values.length];
        int i = 0;
        while (i < values.length) {
            resValue[i] = BcNumberUtil.toPrimitive(values[i]);
            ++i;
        }
        return resValue;
    }

    public static double toPrimitive(Double values) {
        double resValue = 0.0;
        if (values != null) {
            resValue = values;
        }
        return resValue;
    }

    public static Integer[] toIntegerArray(int[] intArray) {
        Integer[] integerArray = new Integer[intArray.length];
        int i = 0;
        while (i < intArray.length) {
            integerArray[i] = intArray[i];
            ++i;
        }
        return integerArray;
    }

    public static int[] toIntArray(Number[] numberArray) {
        int[] newArray = new int[numberArray.length];
        int i = 0;
        while (i < numberArray.length) {
            Number number = numberArray[i];
            newArray[i] = number.intValue();
            ++i;
        }
        return newArray;
    }

    public static int[] toIntArray(Collection<? extends Number> numberCollection) {
        int[] newArray = new int[numberCollection.size()];
        int index = 0;
        for (Number number : numberCollection) {
            newArray[index] = number.intValue();
            ++index;
        }
        return newArray;
    }

    public static long[] toLongArray(Collection<? extends Number> numberCollection) {
        long[] newArray = new long[numberCollection.size()];
        int index = 0;
        for (Number number : numberCollection) {
            newArray[index] = number.longValue();
            ++index;
        }
        return newArray;
    }

    public static List<Byte> toList(byte ... array) {
        ArrayList<Byte> list = new ArrayList<Byte>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static List<Short> toList(short ... array) {
        ArrayList<Short> list = new ArrayList<Short>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static List<Integer> toList(int ... array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static List<Long> toList(long ... array) {
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static List<Float> toList(float ... array) {
        ArrayList<Float> list = new ArrayList<Float>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(Float.valueOf(array[i]));
            ++i;
        }
        return list;
    }

    public static List<Double> toList(double ... array) {
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static String toString(Object src, int decimalPlaces, int groupingSize) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            return null;
        }
        Number number = null;
        if (src instanceof Number) {
            number = (Number)src;
        } else {
            BigDecimal bigDec = BcNumberUtil.parseBigDecimal(src.toString());
            number = bigDec;
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        if (decimalPlaces > 0) {
            decimalFormat.setMaximumFractionDigits(decimalPlaces);
            decimalFormat.setMinimumFractionDigits(decimalPlaces);
        }
        decimalFormat.setGroupingSize(groupingSize);
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer sb = new StringBuffer();
        sb = decimalFormat.format(number, sb, fieldPosition);
        return sb.toString();
    }

    public static String toString(Object src, int decimalPlaces) throws Exception {
        return BcNumberUtil.toString(src, decimalPlaces, 0);
    }

    public static String toString(Object src) throws Exception {
        return BcNumberUtil.toString(src, 0, 3);
    }

    public static String toString3(double value, int decimalPlaces, int mode) throws Exception {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(decimalPlaces, mode);
        return bd.toString();
    }

    public static String toString(double value, int decimalPlaces) throws Exception {
        return BcNumberUtil.toString3(value, decimalPlaces, 4);
    }

    public static BigDecimal clone(BigDecimal bigDecimal) {
        BigDecimal newBigDecimal = bigDecimal.add(BigDecimal.ZERO);
        return newBigDecimal;
    }

    public static StringBuilder toHex(int[] intArray, boolean toUpper, String prefix, String delimiter) throws Exception {
        StringBuilder sb = new StringBuilder(intArray.length * 6);
        int intVal = 0;
        int i = 0;
        while (i < intArray.length) {
            if (!BcStringUtil.isEmpty(delimiter) && sb.length() > 0) {
                sb.append(delimiter);
            }
            if ((intVal = intArray[i]) < 0) {
                intVal = 128 + (128 + intVal);
            }
            String tmpStr = Integer.toString(intVal, 16);
            if (!BcStringUtil.isEmpty(prefix)) {
                sb.append(prefix);
            }
            if (toUpper) {
                sb.append(BcStringUtil.fillPrefix(tmpStr.toUpperCase(), 2, '0'));
            } else {
                sb.append(BcStringUtil.fillPrefix(tmpStr, 2, '0'));
            }
            ++i;
        }
        return sb;
    }

    public static StringBuilder toHex(int[] intArray) throws Exception {
        return BcNumberUtil.toHex(intArray, true, "0x", " ");
    }

    public static StringBuilder toHex(int intValue) throws Exception {
        int[] intArray = new int[]{intValue};
        return BcNumberUtil.toHex(intArray, true, "0x", " ");
    }

    public static StringBuilder toHex(char aChar) throws Exception {
        return BcNumberUtil.toHex((int)aChar);
    }

    public static StringBuilder toHex(byte[] byteArray, boolean toUpper, String prefix, String delimiter) throws Exception {
        int[] intArray = BcByteUtil.toIntArray(byteArray);
        int i = 0;
        while (i < byteArray.length) {
            intArray[i] = byteArray[i];
            ++i;
        }
        return BcNumberUtil.toHex(intArray, toUpper, prefix, delimiter);
    }

    public static StringBuilder toHex(byte[] byteArray, int offSet, int length) throws Exception {
        int[] intArray = BcByteUtil.toIntArray(byteArray, offSet, length);
        return BcNumberUtil.toHex(intArray, true, "x", ",");
    }

    public static StringBuilder toHex(byte[] byteArray) throws Exception {
        return BcNumberUtil.toHex(byteArray, 0, byteArray.length);
    }

    public static BigDecimal roundingDown(int scale, long value) {
        BigDecimal bigDec = new BigDecimal(value);
        bigDec = bigDec.setScale(scale, RoundingMode.DOWN);
        return bigDec;
    }

    public static boolean isIntegeraClass(Class clazz) throws Exception {
        return Byte.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz);
    }

    public static boolean isFloatingaPointClass(Class clazz) throws Exception {
        return Float.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz);
    }

    public static void setValue(BigDecimal setDec, BigDecimal ... bigDecArray) {
        int i = 0;
        while (i < bigDecArray.length) {
            bigDecArray[i] = setDec;
            ++i;
        }
    }

    public static void setZero(BigDecimal ... bigDecArray) {
        BcNumberUtil.setValue(BigDecimal.ZERO, bigDecArray);
    }

    public static boolean isLongRange(Number num) throws Exception {
        return num != null && num.longValue() >= Long.MIN_VALUE && num.longValue() <= Long.MAX_VALUE;
    }

    public static boolean isIntRange(Number num) throws Exception {
        return num != null && num.longValue() >= Integer.MIN_VALUE && num.longValue() <= Integer.MAX_VALUE;
    }

    public static boolean isShortRange(Number number) {
        return number != null && number.longValue() >= -32768L && number.longValue() <= 32767L;
    }

    public static int toIntRoundHalfUp(double value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(0, 4);
        return bigDecimal.intValue();
    }

    public static Number choiceNotNull(Number ... numbers) throws Exception {
        int i = 0;
        while (i < numbers.length) {
            Number number = numbers[i];
            if (number != null) {
                return number;
            }
            ++i;
        }
        return null;
    }

    public static String getSignSymbol(double value, boolean pulusOmission) throws Exception {
        String str = null;
        str = Math.signum(value) >= 0.0 ? (pulusOmission ? "" : PLUS) : MINUS;
        return str;
    }

    public static StringBuilder dump(String src) {
        StringBuilder sb = new StringBuilder();
        char[] charArray = src.toCharArray();
        sb.append("dump(" + src + "): ");
        int i = 0;
        while (i < charArray.length) {
            sb.append(String.valueOf(Integer.toString(charArray[i], 16)) + " ");
            ++i;
        }
        return sb;
    }

    public static boolean isEmpty(int ... values) {
        if (values == null) {
            return true;
        }
        return values.length == 0;
    }

    public static boolean isEmpty(short ... values) {
        if (values == null) {
            return true;
        }
        return values.length == 0;
    }

    public static int minusToZero(int value) {
        return Math.max(0, value);
    }

    public static int compare(long d1, long d2) {
        if (d1 == d2) {
            return BcCompareUtil.Comparison.equals.value;
        }
        if (d1 < d2) {
            return BcCompareUtil.Comparison.small.value;
        }
        return BcCompareUtil.Comparison.big.value;
    }

    public static int compareLong(Number number1, Number number2) {
        if (number1 == null) {
            if (number2 == null) {
                return BcCompareUtil.Comparison.equals.value;
            }
            return BcCompareUtil.Comparison.small.value;
        }
        if (number2 == null) {
            return BcCompareUtil.Comparison.big.value;
        }
        return BcNumberUtil.compare(number1.longValue(), number2.longValue());
    }

    public static int compare(double d1, double d2) {
        if (d1 == d2) {
            return BcCompareUtil.Comparison.equals.value;
        }
        if (d1 < d2) {
            return BcCompareUtil.Comparison.small.value;
        }
        return BcCompareUtil.Comparison.big.value;
    }

    public static int compareDouble(Number number1, Number number2) {
        if (number1 == null) {
            if (number2 == null) {
                return BcCompareUtil.Comparison.equals.value;
            }
            return BcCompareUtil.Comparison.small.value;
        }
        if (number2 == null) {
            return BcCompareUtil.Comparison.big.value;
        }
        return BcNumberUtil.compare(number1.doubleValue(), number2.doubleValue());
    }

    public static StringBuilder extractNumber(CharSequence src) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (src == null) {
            return sb;
        }
        int pos = -1;
        while (++pos < src.length()) {
            char aChar = src.charAt(pos);
            if (aChar < '0' || aChar > '9') continue;
            sb.append(aChar);
        }
        return sb;
    }

    public static boolean isNumber(CharSequence src) throws Exception {
        if (src == null) {
            return false;
        }
        int pos = -1;
        while (++pos < src.length()) {
            char aChar = src.charAt(pos);
            if (aChar >= '0' && aChar <= '9' || aChar == ',') continue;
            return false;
        }
        return true;
    }

    public void test_01() throws Exception {
        Number ex2;
        try {
            Integer n = BcNumberUtil.toInteger(1.234567897897E12);
        }
        catch (Exception ex2) {
            BcLogUtil.error(ex2);
        }
        try {
            ex2 = BcNumberUtil.toShort(1.234567897897E12);
        }
        catch (Exception ex3) {
            BcLogUtil.error(ex3);
        }
        try {
            ex2 = BcNumberUtil.toByte(1270.0);
        }
        catch (Exception ex4) {
            BcLogUtil.error(ex4);
        }
    }
}

