/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.core;

import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;

public final class BcBooleanUtil {
    public static final String Y = "Y";
    public static final String N = "N";
    public static final String Yes = "Yes";
    public static final String No = "No";

    private BcBooleanUtil() {
    }

    public static short toShort(boolean bool) {
        if (bool) {
            return BcConstants.Existence.TRUE.value;
        }
        return BcConstants.Existence.FALSE.value;
    }

    public static short toShort(String str) {
        return BcBooleanUtil.toShort(BcBooleanUtil.parseBoolean(str));
    }

    public static boolean toBoolean(long num) {
        return num != (long)BcConstants.Existence.FALSE.value;
    }

    public static Boolean parseBoolean(String str, boolean nullable) {
        if (BcStringUtil.isEmpty(str) && nullable) {
            return false;
        }
        if (BcStringUtil.equalsIgnoreCase(str, Y) || BcStringUtil.equalsIgnoreCase(str, Yes)) {
            return Boolean.TRUE;
        }
        return Boolean.parseBoolean(str);
    }

    public static Boolean parseBoolean(String str) {
        return BcBooleanUtil.parseBoolean(str, false);
    }

    public static boolean isBoolean(Class clazz) {
        return Boolean.class.isAssignableFrom(clazz);
    }

    public static boolean isTrue(Object value) {
        return BcBooleanUtil.parseBoolean(BcStringUtil.toString(value), false);
    }

    public static String toYN(boolean bool) {
        if (bool) {
            return Y;
        }
        return N;
    }

    public static String toYN(int num) {
        return BcBooleanUtil.toYN(BcBooleanUtil.toBoolean(num));
    }

    public static String toYesNo(boolean bool) {
        if (bool) {
            return Yes;
        }
        return No;
    }
}

