/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.dao;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf8.model.KscfWord;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class KscfWordDAO
extends OrmAbstractDAO {
    private KscfWordDAO() {
        super(new Object[0]);
        this.setTableName("frwk_word");
    }

    public static KscfWordDAO getInstance() {
        return SingletonHolder.instance;
    }

    public int putWord(DtsSession dtsSession, KscfWord fwWord) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        StringBuilder query = new StringBuilder();
        query.append("UPDATE " + this.tableName + " SET " + "value_=" + sqlContext.toSet(fwWord.value) + " WHERE " + "domain_id=" + fwWord.domainId + " AND " + "word_code" + sqlContext.toCondition_string("=", fwWord.wordCode) + " AND " + "language_code" + sqlContext.toCondition_string("=", fwWord.languageCode));
        int recCnt = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            recCnt = stmt.executeUpdate(query.toString());
        }
        if (recCnt > 0) {
            return recCnt;
        }
        query = new StringBuilder();
        query.append("INSERT INTO " + this.tableName + " (" + " domain_id" + ",word_code" + ",language_code" + ",value_" + ") VALUES (" + fwWord.domainId + "," + sqlContext.toSet(fwWord.wordCode) + "," + sqlContext.toSet(fwWord.languageCode) + "," + sqlContext.toSet(fwWord.value) + ")");
        stmt = dtsSession.getConnection().createStatement();
        try {
            recCnt = stmt.executeUpdate(query.toString());
        }
        finally {
            stmt.close();
        }
        return recCnt;
    }

    public List<KscfWord> getWordList(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        StringBuilder query = new StringBuilder();
        query.append("SELECT word_code, language_code, value_ FROM " + this.tableName);
        Object wordValue = null;
        ArrayList<KscfWord> wordList = new ArrayList<KscfWord>();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query.toString());
            while (rs.next()) {
                KscfWord fwWord = new KscfWord();
                fwWord.wordCode = rs.getString(1);
                fwWord.languageCode = rs.getString(2);
                fwWord.value = rs.getString(3);
                wordList.add(fwWord);
            }
            rs.close();
        }
        return wordList;
    }

    /* synthetic */ KscfWordDAO(KscfWordDAO kscfWordDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final KscfWordDAO instance = new KscfWordDAO(null);

        private SingletonHolder() {
        }
    }
}

