/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.fx;

import java.util.ArrayList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.rmi.common.RmiLoggerConstants;
import jp.co.extreme.scf4.client.ScfAbstractProcessingMonitor;
import jp.co.extreme.scf4.fx.HfxConsolePane;

public class HfxProcessingPane
extends ScfAbstractProcessingMonitor {
    protected FxDecoratePane decoratePane = new FxDecoratePane();
    protected FlowPane bottomPane = new FlowPane();
    protected FxTextField elapsedTimeField = new FxTextField();
    protected FxTextField dataSizeField = new FxTextField();
    protected Pane rightPane = new Pane();
    public HfxConsolePane consolePane = new HfxConsolePane();
    protected Window ownerWindow;
    protected String title;
    protected Stage stage;
    public boolean successfullyMessageEnable = true;
    boolean isTop;

    public HfxProcessingPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.bottomPane.getChildren().add((Object)this.elapsedTimeField);
        this.bottomPane.getChildren().add((Object)this.dataSizeField);
        this.decoratePane.setBottom((Node)this.bottomPane);
        this.decoratePane.setCenter((Node)this.consolePane);
        FxUtil.setFont((Node)this.decoratePane, FxFontUtil.font_11b);
        FxUtil.setEditable((Node)this.decoratePane, false);
    }

    @Override
    protected void successed() {
        super.successed();
        this.isTop = true;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HfxProcessingPane.this.successed_L2();
                }
                catch (Exception ex) {
                    HfxProcessingPane.this.getLogger().error(ex);
                }
            }
        });
    }

    protected void successed_L2() throws Exception {
        this.close();
        if (!this.successfullyMessageEnable) {
            return;
        }
        Object resultObj = this.rmiRes.getObject("result");
        if (resultObj == null) {
            String msg = String.valueOf(this.title) + "\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002";
            FxOptionPane.showMessageDialog(this.ownerWindow, (Object)msg, BcWords.getInstance().information, 1);
        } else if (resultObj instanceof BcResult) {
            BcResult result = (BcResult)resultObj;
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog(this.ownerWindow, (Object)msg, BcWords.getInstance().error, 0);
            } else {
                ArrayList<Object> msgList = new ArrayList<Object>();
                if (result.hasInfo()) {
                    msgList.addAll(result.getInfoList());
                }
                if (result.hasWarn()) {
                    msgList.addAll(result.getWarnList());
                }
                String msg = BcMessageCreator.getInstance().createMessage(msgList).toString();
                FxOptionPane.showMessageDialog(this.ownerWindow, (Object)msg, BcWords.getInstance().information, 1);
            }
        } else {
            String msg = BcStringUtil.toStringNotNull(resultObj);
            FxOptionPane.showMessageDialog(this.ownerWindow, (Object)msg, BcWords.getInstance().information, 1);
        }
        this.unLock();
    }

    @Override
    protected void exceptionOccurred(final Throwable throwable) {
        super.exceptionOccurred(throwable);
        this.isTop = true;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                HfxProcessingPane.this.close();
                String message = throwable.toString();
                FxOptionPane.showMessageDialog(HfxProcessingPane.this.ownerWindow, (Object)message, BcWords.getInstance().exception, 0);
                HfxProcessingPane.this.unLock();
            }
        });
    }

    protected void loopL1() {
        this.isTop = false;
        while (!this.isTop) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            final String elapsedTimeStr = BcTimeUtil.toDurationString(elapsedTime);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    Object data;
                    HfxProcessingPane.this.dataSizeField.setText(Integer.toString(HfxProcessingPane.this.dataQueue.size()));
                    HfxProcessingPane.this.elapsedTimeField.setText(elapsedTimeStr);
                    while ((data = HfxProcessingPane.this.dataQueue.poll()) != null) {
                        byte[] dataBytes = (byte[])data;
                        String str = new String(dataBytes, RmiLoggerConstants.CHARSET);
                        HfxProcessingPane.this.consolePane.addLine(str);
                    }
                }
            });
            try {
                Thread.sleep(200L);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }

    public void close() {
        this.stage.close();
        this.stage = null;
    }

    protected void unLock() {
    }

    public void show(String title, Window ownerWindow, boolean isWait) throws Exception {
        this.title = title;
        this.ownerWindow = ownerWindow;
        this.stage = new FxStage(StageStyle.UTILITY);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    HfxProcessingPane.this.windowShown();
                }
                catch (Exception ex) {
                    HfxProcessingPane.this.exceptionOccurred(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                if (!HfxProcessingPane.this.isTop) {
                    ev.consume();
                }
            }
        });
        FxScene scene = new FxScene((Parent)this.decoratePane);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(620.0);
        this.stage.setHeight(360.0);
        this.stage.setResizable(true);
        this.stage.setTitle(title);
        if (isWait) {
            this.stage.showAndWait();
        } else {
            this.stage.show();
        }
    }

    public void show(String title, Window ownerWindow) throws Exception {
        this.show(title, ownerWindow, false);
    }

    protected void windowShown() throws Exception {
        DrawSerivce drawSerivce = new DrawSerivce();
        drawSerivce.restart();
    }

    public class DrawSerivce
    extends Service {
        protected Task createTask() {
            return new Task<Void>(){

                protected Void call() throws Exception {
                    HfxProcessingPane.this.doConnect();
                    HfxProcessingPane.this.loopL1();
                    return null;
                }
            };
        }
    }
}

