/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.rmi.server;

import java.io.File;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.app.common.ApXmlUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.rmi.server.RmiServer;
import jp.co.extreme.scf.rmi.server.RmiLogHandlerImpl;
import jp.co.extreme.scf.server.ScfAbstractServerModule;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RmiServerModule
extends ScfAbstractServerModule {
    protected String loggerName = "rmi_server";
    public RmiServer rmiServer = new RmiServer();

    @Override
    public void setModuleNode(Node domNode) throws Exception {
    }

    @Override
    public void init() throws Exception {
        String logFilePath = String.valueOf(ApApplication.getInstance().toReal("${APP}log/")) + "rmix_server.log";
        BcLogger logger = BcLogUtil.createLogger(this.loggerName, false, BcLogConstants.LogLevel.INFO, true, new File(logFilePath));
        this.setLogger(logger);
        this.rmiServer.setLogger(this.getLogger());
        if (ApApplication.getInstance().isServer()) {
            String cofigPath = ApApplication.getInstance().toReal("${APP}config/rmix_server.xml");
            File configFile = new File(cofigPath);
            if (!configFile.exists()) {
                this.getLogger().info("RMI Server config file is not found.");
                return;
            }
            Document configDom = BcXmlUtil.createDocument(configFile);
            Node node_tcpListen = BcXmlUtil.getNode(configDom, "tcpListen");
            BcAddressPort addressPort = new BcAddressPort();
            ApXmlUtil.parseAddressPort(node_tcpListen, addressPort);
            this.rmiServer.setAddressPort(addressPort);
            this.rmiServer.heartBeatCheckInterval = BcNumberUtil.parseLong(BcXmlUtil.getTextValue(configDom, "heartBeat/checkInterval"), -1L);
            this.rmiServer.heartBeatDropMillis = BcNumberUtil.parseLong(BcXmlUtil.getTextValue(configDom, "heartBeat/dropTime"), -1L);
            this.rmiServer.clientMax = BcNumberUtil.parseInteger(BcXmlUtil.getTextValue(configDom, "clientMax"), -1);
            this.getLogger().info("lintenAddress=" + addressPort.address);
            this.getLogger().info("lintenPort=" + addressPort.port);
            this.getLogger().info("heartBeatCheckInterval=" + this.rmiServer.heartBeatCheckInterval);
            this.getLogger().info("heartBeatDropTime=" + this.rmiServer.heartBeatDropMillis);
            this.getLogger().info("clientMax=" + this.rmiServer.clientMax);
        } else {
            BcAddressPort addressPort = new BcAddressPort();
            addressPort.address = "localhost";
            addressPort.port = 0;
            this.rmiServer.setAddressPort(addressPort);
        }
    }

    @Override
    public void start() throws Exception {
        this.rmiServer.logHandler = new RmiLogHandlerImpl();
        this.rmiServer.init();
    }

    @Override
    public void end() throws Exception {
        this.rmiServer.stop();
    }

    public RmiServer getServer() {
        return this.rmiServer;
    }
}

