/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rmi.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.rmi.agent.RmiAgent;
import jp.co.extreme.rmi.agent.RmiAgentContext;
import jp.co.extreme.rmi.common.RmiMethodContext;
import jp.co.extreme.rmi.connector.RmiConnector;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.rmi.rmo.RmiHeartBeatRMO;
import jp.co.extreme.rmi.server.RmiAcceptThread;
import jp.co.extreme.rmi.server.RmiAgentEventHandler;
import jp.co.extreme.rmi.server.RmiLogHandler;
import jp.co.extreme.rmi.server.RmiRedirector;
import jp.co.extreme.rmi.server.RmiRemoteAgent;
import jp.co.extreme.rmi.server.RmiRmoInvoker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RmiServer
extends BcLoggableObject {
    protected String loggerName = "rmi_server";
    protected BcAddressPort addressPort;
    protected int acceptBacklogCount = 8;
    public long heartBeatCheckInterval = 60000L;
    public long heartBeatDropMillis = 20000L;
    public int clientMax = 100;
    public RmiAcceptThread acceptThread;
    protected RmiRmoInvoker rmoInvoker;
    protected final List<RmiAgent> rmiAgentList = new ArrayList<RmiAgent>();
    public List<RmiAgentEventHandler> agentEventHandlerList = new ArrayList<RmiAgentEventHandler>();
    protected RmiRedirector redirector;
    ExecutorService executorService = Executors.newCachedThreadPool();
    protected Timer timer;
    RmiRequest rmiReq1 = new RmiRequest();
    public RmiLogHandler logHandler;

    public RmiServer() {
        this.rmiReq1.setClassName(RmiHeartBeatRMO.class.getName());
        this.rmiReq1.setMethodName("isLife");
    }

    public void init() throws Exception {
        this.rmoInvoker = new RmiRmoInvoker();
        this.rmoInvoker.setAgentEventHandlerList(this.agentEventHandlerList);
        if (this.heartBeatCheckInterval > 0L) {
            HeartBeatCheckTask heartBeatCheckTask = new HeartBeatCheckTask();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)heartBeatCheckTask, this.heartBeatCheckInterval, this.heartBeatCheckInterval);
        }
        this.acceptThread = new RmiAcceptThread(this);
        this.getLogger().info("addressPort=" + this.addressPort);
        if (this.addressPort != null) {
            this.acceptThread.startAccept(this.addressPort.address, this.addressPort.port, this.acceptBacklogCount);
        }
    }

    public void stop() throws Exception {
        this.acceptThread.stopThread();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public BcAddressPort getAddressPort() {
        return this.addressPort;
    }

    public void setAddressPort(BcAddressPort addressPort) {
        this.addressPort = addressPort;
    }

    public void setupRmoMapping(Node domNode) throws Exception {
        NodeList domNodeList = domNode.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode2 = domNodeList.item(i);
            if (domNode2.getNodeName().equals("rmoContext")) {
                RmiMethodContext methodContext = new RmiMethodContext();
                String jndiName = BcXmlUtil.getTextValue(domNode, "rmoName");
                methodContext.className = BcXmlUtil.getTextValue(domNode, "class");
                methodContext.methodName = BcXmlUtil.getTextValue(domNode, "method");
                this.rmoInvoker.addMethodContext(jndiName, methodContext);
            }
            ++i;
        }
    }

    public void addAgentEventHandler(RmiAgentEventHandler agentEventHandler) {
        this.agentEventHandlerList.add(agentEventHandler);
    }

    public boolean removeAgentEventHandler(RmiAgentEventHandler agentEventHandler) {
        return this.agentEventHandlerList.remove(agentEventHandler);
    }

    public RmiRmoInvoker getRmoInvoker() {
        return this.rmoInvoker;
    }

    public List<RmiAgent> getAgentList() {
        return this.rmiAgentList;
    }

    public int getClientCount() {
        return this.rmiAgentList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteAgent(RmiRemoteAgent remoteAgent) {
        remoteAgent.setServer(this);
        List<RmiAgent> list = this.rmiAgentList;
        synchronized (list) {
            this.getLogger().info("addRemoteAgent:agentId=" + remoteAgent.getAgentId());
            this.rmiAgentList.add(remoteAgent);
            RmiAgentEventHandler[] rmixAgentEventHandlers = this.agentEventHandlerList.toArray(new RmiAgentEventHandler[0]);
            int i = 0;
            while (i < rmixAgentEventHandlers.length) {
                RmiAgentEventHandler eventHandler = rmixAgentEventHandlers[i];
                try {
                    eventHandler.agentAdded(remoteAgent);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteAgent(RmiRemoteAgent remoteAgent, Object note) throws Exception {
        this.getLogger().info("removeRemoteAgent:agentId=" + remoteAgent.getAgentId());
        this.getLogger().info("removeRemoteAgent:note=" + note);
        List<RmiAgent> list = this.rmiAgentList;
        synchronized (list) {
            boolean isSuccess = this.rmiAgentList.remove(remoteAgent);
            if (isSuccess) {
                remoteAgent.destruct();
                RmiAgentEventHandler[] agentEventHandlers = this.agentEventHandlerList.toArray(new RmiAgentEventHandler[0]);
                int i = 0;
                while (i < agentEventHandlers.length) {
                    RmiAgentEventHandler eventHandler = agentEventHandlers[i];
                    try {
                        eventHandler.agentRemoved(remoteAgent);
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                    ++i;
                }
            } else {
                this.getLogger().info("removeRemoteAgent:agentId='" + remoteAgent.getAgentId() + "' \u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
    }

    public RmiAgent getAgent(int agentId) throws Exception {
        RmiAgent[] rmixAgents = this.rmiAgentList.toArray(new RmiAgent[0]);
        int i = 0;
        while (i < rmixAgents.length) {
            RmiAgent rmixAgent = rmixAgents[i];
            if (rmixAgent.getAgentId() == agentId) {
                return rmixAgent;
            }
            ++i;
        }
        return null;
    }

    public void checkAgentLife() {
    }

    public void checkAgentLife_L2(RmiRemoteAgent remoteAgent) throws Exception {
        RmiAgentContext agentContext = remoteAgent.getContext();
        RmiConnector connector = remoteAgent.getConnector();
        if (remoteAgent.getConnector() == null) {
            this.removeRemoteAgent(remoteAgent, "checkAgentLife:#1");
        } else if (!remoteAgent.getConnector().isOpen()) {
            this.removeRemoteAgent(remoteAgent, "checkAgentLife:#2");
        }
        RmiRespons rmiRes = connector.sendRequest(this.rmiReq1);
        boolean isLife = rmiRes.getDataAsBoolean();
        if (!isLife) {
            this.removeRemoteAgent(remoteAgent, "checkAgentLife:#3");
        }
    }

    public RmiRedirector getRedirector() {
        return this.redirector;
    }

    public void setRedirector(RmiRedirector redirector) {
        this.redirector = redirector;
    }

    class HeartBeatCheckTask
    extends TimerTask {
        HeartBeatCheckTask() {
        }

        @Override
        public void run() {
            try {
                RmiServer.this.checkAgentLife();
            }
            catch (Exception ex) {
                RmiServer.this.getLogger().error(ex);
            }
        }
    }
}

